/**                   
 * Cart.java          
 * @author Wrox Press 
 * @version 1.0       
 */ 

package com.wrox.projsp.ch16;

import java.util.ArrayList;// JDK 2
//import com.sun.java.util.collections.ArrayList; // JDK 1.1 + collections

public class Caddy
{
	ArrayList	notreCaddy		= new ArrayList();
	float		prixTotal	= (float)0;
   
	private void addProduit(Produit p) 
	{
		notreCaddy.add(p);
    }

    private void removeItem(int n) 
	{
		notreCaddy.remove(n);
    }
   	

	public void setItem(String [] b) 
	{
	
		for(int i = 0; i < b.length; i++)
		{
			Produit p = ReferenceProduit.getProduit(Integer.parseInt(b[i]));
			addProduit(p);
		}
		
		calculerNouveauPrix();
    }

	public void setRemoval(String [] b) 
	{
		int itemIndex;

		for(int i = 0; i < b.length; i++)
		{
			itemIndex = Integer.parseInt(b[i]);
			removeItem(itemIndex);

		}

		calculerNouveauPrix();
    }
    
	private void calculerNouveauPrix()
	{
		prixTotal = 0;

		for(int i=0; i < notreCaddy.size(); i++)
		{
			Produit p = (Produit)notreCaddy.get(i);
			prixTotal = prixTotal + (Float.valueOf(p.getPrix()).floatValue());
		}
	}

    public ArrayList getItems() 
	{	
		return notreCaddy;
    }
    
	public String getPrix() 
	{
		String prix = String.valueOf(prixTotal); 
		int index = prix.indexOf(".");
		int nombreDecimal = prix.length() - index;
		if(nombreDecimal > 2)
			prix = prix.substring(0, index + 3);

		return prix + " F ";
    }

	public String getNombreItem() 
	{
		String compteur = new Integer(notreCaddy.size()).toString();
		return compteur;
    }


}