/**                   
 * Catalogue.java          
 * @author Wrox Press 
 * @version 1.0       
 */ 

package com.wrox.projsp.ch16;


import java.util.ArrayList;// JDK 2
//import com.sun.java.util.collections.ArrayList; // JDK 1.1 + collections

import java.io.*;

public class Catalogue 
		implements com.wrox.projsp.ch16.Constantes
{

	static int NOMBRE_DE_PRODUITS_PAR_PAGE = 4;

	static ArrayList notreCatalogue = new ArrayList();
	int indexPageCourante = 0;
	

	public Catalogue()
	{
		chargerCatalogue();
	}

	private void chargerCatalogue()
	{
		FileInputStream		fis  = null;
	    StreamTokenizer		in;
		String nom, image, prix;
		Produit produit;
		ArrayList pageCatalogue = new ArrayList();
		
		try 
		{

			fis = new FileInputStream(CATALOGUE_DONNEES); 
			Reader r = 
				new BufferedReader(new InputStreamReader(fis)); 
				System.out.println("Apres lecture"+r.toString());
			in  = new StreamTokenizer(r); 
			int c = 0;
			int refNumber = 0;

		    in.nextToken();
		    while(in.ttype != in.TT_EOF) 
			{

				nom = new String(in.sval);
				System.out.println("nom "+nom);
				in.nextToken();
				System.out.println("TTYPE "+in.ttype);
				image = new String(in.sval);
				System.out.println("image "+image);
				in.nextToken();

								
				prix = new String(in.sval);
				System.out.println("prix "+prix);
				
				in.nextToken();

				produit = new Produit(nom, image, prix, refNumber);
				System.out.println("Produit cree");
				
				pageCatalogue.add(produit);
				System.out.println("Produit ajoute");

				ReferenceProduit.addProduit(produit);

				c = c + 1;
				// il y aura quatre produits par page //
				if(c == NOMBRE_DE_PRODUITS_PAR_PAGE) 
				{
					notreCatalogue.add(pageCatalogue);
					pageCatalogue = new ArrayList();
					c = 0;
				}

				refNumber = refNumber + 1;

			}
		}
		catch (FileNotFoundException fnfe) 
		{
			System.err.println("Fichier non trouv: " + fnfe );
		}
		catch (IOException ioe) 
		{
			System.err.println( ioe.getMessage() );
		} 
		finally // on ferme InputStream //
		{
			try 
			{
				if (fis!=null) fis.close();
	        } 
			catch (IOException e) {}
      }

	}

	//** Setter methodes **//
	public void setIndexPageCourante(String selection) 
	{
		if(selection.equals("augmenter") && indexPageCourante != (notreCatalogue.size() - 1))
			indexPageCourante = indexPageCourante + 1;
		else if(selection.equals("diminuer") && indexPageCourante != 0)
			indexPageCourante = indexPageCourante - 1;
		else if(selection.equals("augmenter") && indexPageCourante == (notreCatalogue.size() -1))
			indexPageCourante = 0;
		else if(selection.equals("diminuer") && indexPageCourante == 0)
			indexPageCourante = (notreCatalogue.size() - 1);
    }

	// L'index de la page courante  //
	public String getIndexPageCourante() 
	{
		return String.valueOf(indexPageCourante);
    }

	// Le nombre de pages dans le catalogue  //
	public String getCataloguePageCount() 
	{
		return String.valueOf(notreCatalogue.size());
    }

	// Retourne la page pass en paramtre # //
	public ArrayList getPageCatalogue() 
	{
		return (ArrayList)notreCatalogue.get(indexPageCourante);
    }
    
    public  static void main(String args[]) {
    	Catalogue c = new Catalogue();	
    }
	
}