/**
 * ControleurAcces.java
 * @author Wrox Press
 * @version 1.0
 */

package com.wrox.projsp.ch16;

import netscape.ldap.*;

import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;


public class ControleurAcces 
			extends HttpServlet implements Constantes
{
	private LDAPConnection ld;

    public void doPost (HttpServletRequest req, HttpServletResponse res)
	throws ServletException, IOException
    {
		//stocker la valeur de l'ID utilisateur
		String utilisateurID		= req.getParameter("ID");		
		// Stocker la valeur du mot de passe
		String motDePasse		= req.getParameter("motDePasse"); 

	if (!autoriserUtilisateur(utilisateurID, motDePasse))
		{
			 // Utilisateur non accept. L'en informer
			 res.sendRedirect ("/prosjp/ch16/nonAutorise.html");
		}
		else 
		{
		
			// Utilisateur authentifi,
      		// rcupration de ses attributs
      
			String utilisateurAttrb = retrouverAttributsUtilisateur(utilisateurID);
			System.out.println("UtilisateurAttrb retourne "+utilisateurAttrb);
			res.sendRedirect ("/projsp/ch16/shoppingMall.jsp?" + utilisateurAttrb);
		}
    }

	private String retrouverAttributsUtilisateur(String uid)
	{
	
			if (ld == null)
		{
			ld = new LDAPConnection();
		}

		String attrs []			= {"uid","givenname","sn","mail", "telephonenumber",
									"street", "l", "st", "postalCode"};
		String SEARCH_FILTER	= "uid=" + uid;
		LDAPSearchResults res	= null;

		StringBuffer sb = new StringBuffer();
		//sb.append(java.net.URLEncoder.encode("uid=bbunny&givenname=bugs&sn=bunny&mail=bbunny@airius.com&telephonenumber=03 20 20 39 43&street=43 Ellis Street&l=Paris&st=Ile de france&postalCode=94093"));
		
		try
		{
			res = ld.search(LDAP_SEARCHBASE, 
			  			    LDAPConnection.SCOPE_SUB,
							SEARCH_FILTER,
							attrs, 
							false );
				
			// Obtenir les rsultats individuels 
			while (res.hasMoreElements())
			{
				LDAPEntry entreeTrouvee = null; 
				entreeTrouvee = (LDAPEntry) res.next();

				LDAPAttributeSet attributeSet = entreeTrouvee.getAttributeSet();

				for (int i=0; i < attributeSet.size(); i++)
				{
					LDAPAttribute attribute = 
									  (LDAPAttribute)attributeSet.elementAt(i);
					String nomAttribut = attribute.getName();
					sb.append("&");
					sb.append(java.net.URLEncoder.encode(nomAttribut));
					sb.append("=");
				   
					Enumeration enumVals = attribute.getStringValues();

					if (enumVals != null) 
					{
					  while ( enumVals.hasMoreElements() ) 
					  {
						 String valeurSuivante = ( String )enumVals.nextElement();
						 sb.append(java.net.URLEncoder.encode( valeurSuivante ));
					  }
				   }
				}
			}

		}
		catch(LDAPException e)
		{
			 e.printStackTrace();
		}
		finally 
		{	
			try 
			{
				if (ld != null) ld.disconnect();
			}
		catch (LDAPException e) {}
		}

		return sb.toString();
	}

/* Cette mthode vrifie si unutilisateur est dans le dictionnaire LDAP */
	private boolean autoriserUtilisateur(String uid, String pwd) 
											throws IOException 
	{
		// ensemble des 2 champs ont besoin d'tre rempli
		if(uid.equals("") || pwd.equals(""))
			return false;
		
		ld = new LDAPConnection();
		LDAPEntry entreeTrouvee = null;
		String dn = null;

		boolean status = false;

		try 
		{

		 String monFiltre = "uid=" + uid;
		 ld.connect( HOST_NAME, LDAP_PORT );

		 LDAPSearchResults res = null;
		 res = ld.search(LDAP_SEARCHBASE, LDAPConnection.SCOPE_SUB,
							monFiltre,null,false);

			while (res.hasMoreElements()) 
			{ 
				entreeTrouvee = res.next(); 
				dn = entreeTrouvee.getDN(); 

				//se lier maintenant au serveur 
				ld.authenticate(dn,pwd);

				// si aucune exception n'est lance
				// le processus est un succs
			
				status = true; 
			} 

		}
		catch(LDAPException e) 
		{
		 System.out.println(e.toString()); 
		}
		catch(Exception x) 
		{ 
			x.printStackTrace(); 
		}
	  
	  return status; 
   }

    public String getServletInfo() 
	{
		return "Exemple de Servlet Pro JSP - Wrox Presse Inc.";
    }
}