/**                   
 * Utilisateur.java          
 * @author Wrox Press 
 * @version 1.0       
 */ 

package com.wrox.projsp.ch16;

import netscape.ldap.*;
import java.util.*;


public class Utilisateur 
		implements com.wrox.projsp.ch16.Constantes
{

	String	uid				= ""; 
	String	motDePasse		= ""; 
	String	surnom		= ""; 
	String	sn				= ""; 
	String	rue			= ""; 
	String	l				= ""; 
	String	st				= "";  
	String	codePostal		= ""; 
	String	telephone	= ""; 
	String	rueLivraison	= ""; 
	String	villeLivraison		= ""; 
	String	departementLivraison		= "";  
	String	codePostalLivraison		= ""; 
	String	mail			= ""; 
	String	choix			= null; 

	// setter methods //
	public void setUid(String nom) 
	{ 
		uid			= nom;
	} 


	/* METHODES  EN ANGLAIS POUR PERMETTRE INSTANTIATION BEAN */
	public void setPassword(String nom) 
	{ 
		setMotDePasse(nom); 
	} 

    public void setGivenname(String nom)	
	{
		setSurnom(nom);
    }

	    public void setStreet(String nom)
	{
		setRue(nom);
    }

	public void setPostalCode(String nom)	
	{
		setCodePostal(nom);
  }

	public void setTelephonenumber(String nom)	
	{
		setTelephone(nom);
	}
	/* FIN METHODES  EN ANGLAIS POUR PERMETTRE INSTANTIATION BEAN */

	
	
	public void setMotDePasse(String nom) 
	{ 
		motDePasse = nom; 
	} 

    public void setSurnom(String nom)	
	{
		surnom = nom;
    }
	
	public void setSn(String nom) 
	{
		sn = nom;
    }

    public void setRue(String nom)
	{
		rue = nom;
    }

	public void setL(String nom)
	{
		l = nom;
    }

	public void setSt(String nom)
	{
		st = nom;
    }

	public void setCodePostal(String nom)	
	{
		codePostal = nom;
    }

	public void setTelephone(String nom)	
	{
		telephone = nom;
    }

	public void setRueLivraison(String nom)
	{
		rueLivraison = nom;
    }

	public void setVilleLivraison(String nom)
	{
		villeLivraison = nom;
    }

	public void setDepartementLivraison(String nom)
	{
		departementLivraison = nom;
    }

	public void setCodePostalLivraison(String nom)	
	{
		codePostalLivraison = nom;
    }

	public void setMail(String nom)
	{
		mail = nom;
    }
    
	// mthodes de rcupration //
  public boolean getUidIsSet() { 
    return isUIDSet(); 
  }

  public String getUid() { 
    return uid; 
  } 


	public String getMotDePasse() 
	{ 
		return motDePasse; 
	} 

	public String getSurnom() 
	{
		return surnom;
    }

	public String getSn() 
	{
		return sn;
    }

    public String getRue() 
	{
		return rue;
    }

	public String getL() 
	{
		return l;
    }

	public String getSt() 
	{
		return st;
    }

	public String getTelephone() 
	{
		return telephone;
    }

	public String getCodePostal() 
	{
		return codePostal;
    }

	public String getRueLivraison() 
	{
		return rueLivraison;
    }

	public String getVilleLivraison() 
	{
		return villeLivraison;
    }

	public String getDepartementLivraison() 
	{
		return departementLivraison;
    }

	public String getCodePostalLivraison() 
	{
		return codePostalLivraison;
    }

	public String getMail() 
	{
		return mail;
    }

   public void setChoix(String s) 
   {
		choix = s;
		if (choix != null && choix.startsWith("Creer"))
			sauverNouveauProfil();
		
		reset();
   }

    // reset
    private void reset() 
	{
		choix = null;
    }

	private void sauverNouveauProfil()
	{
		
		String nouveau_dn = "uid=" + uid + ",ou=People, o=airius.com";
		String objectclass_valeur [] = 
						  {"top","person","organizationalperson","inetorgperson"};
		String cn_valeur [] = {surnom + " " +  sn};
		String sn_valeur [] = {sn};
		String surnom_valeur [] = {surnom};
		String uid_valeur [] = {uid};
		String mail_valeur[] = {mail}; 
		String rue_valeur[] = {rue};
		LDAPAttributeSet attrib_set = null;
		LDAPAttribute attribut = null;
		LDAPEntry entree = null;

		LDAPConnection ld = null;

		try
		{
			 ld = new LDAPConnection();

			 /* on doit avoir les droits d'criture dans LDAP */
			 ld.connect(HOST_NAME, LDAP_PORT, ADMIN_DN, ADMIN_PWD);
			 attrib_set = new LDAPAttributeSet();

			 attribut = new LDAPAttribute("objectclass",objectclass_valeur);
			 attrib_set.add(attribut);

			 attribut = new LDAPAttribute("cn", cn_valeur);
			 attrib_set.add(attribut);

			 attribut = new LDAPAttribute("sn", sn_valeur);
			 attrib_set.add(attribut);

			 attribut = new LDAPAttribute("givenname",surnom_valeur);
			 attrib_set.add(attribut);

			 attribut = new LDAPAttribute("mail", mail_valeur);
			 attrib_set.add(attribut);

			 attribut = new LDAPAttribute("ou", "People");
			 attrib_set.add(attribut);

			 attribut = new LDAPAttribute("uid",uid_valeur);
			 attrib_set.add(attribut);

			 attribut = new LDAPAttribute("userPassword", motDePasse);
			 attrib_set.add(attribut);

			 attribut = new LDAPAttribute("rue", rue_valeur);
			 attrib_set.add(attribut);

			 attribut = new LDAPAttribute("l", l);
			 attrib_set.add(attribut);

			 attribut = new LDAPAttribute("st", st);
			 attrib_set.add(attribut);

			 attribut = new LDAPAttribute("postalCode", codePostal);
			 attrib_set.add(attribut);

			 attribut = new LDAPAttribute("telephonenumber", telephone);
			 attrib_set.add(attribut);

			 /* Creation de l'entre de l'objet */
			 entree = new LDAPEntry(nouveau_dn,attrib_set);

			 /* add the object */
			 ld.add(entree);

			 if (ld != null)
			 { 
				ld.disconnect();
			 }
		}
		catch(LDAPException e)
		{
			 e.printStackTrace();
		}
	}

public boolean isUIDSet() { 
  if(uid.equals("") || uid == null) {
    return false;
  } else {
    return true;
  }
}

}