package com.wrox.projsp.ch18;

// Dbut de RTPMediaApplet.java
import java.applet.Applet;
import java.io.*;
import java.awt.*;
import java.util.Vector;
import java.net.*;
import javax.media.*;
import javax.media.protocol.*;
import javax.media.rtp.*;
import javax.media.rtp.rtcp.*;
import javax.media.rtp.event.*;
import com.sun.media.rtp.RTPSessionMgr;

public class RTPMediaApplet extends Applet 
  implements ControllerListener, ReceiveStreamListener {
  InetAddress destaddr;
  String adresse;
  String portstr;
  String media;
  Player videoplayer = null;
  Player audioplayer = null;
  SessionManager videosm = null;
  SessionManager audiosm = null;
  Component composantVisuel = null;
  int largeur = 160;
  int hauteur = 120;
  
  public void init() {
    int port;
    media = getParameter("video");
    if (media.equals("On")) {
      adresse = getParameter("videosession");
      portstr = getParameter("videoport");
      port = (new Integer(portstr)).intValue();
      videosm = createSessionManager(adresse, port);
      if (videosm == null) {
        return;
      } 
    } 
    media = getParameter("audio");
    if (media.equals("On")) {
      adresse = getParameter("audiosession");
      portstr = getParameter("audioport");
      port = (new Integer(portstr)).intValue();
      audiosm = createSessionManager(adresse, port);
      if (audiosm == null) {
        return;
      } 
    } 
  }
  
  public void start() {
    if (videoplayer != null) {
      videoplayer.start();
    } 
    if (audioplayer != null) {
      audioplayer.start();
    } 
  }
  
    public void update(ReceiveStreamEvent evenement) {
    SessionManager source = (SessionManager) evenement.getSource();
    Player newplayer = null;
    if (evenement instanceof NewReceiveStreamEvent) {
      try {
        ReceiveStream stream = 
          ((NewReceiveStreamEvent) evenement).getReceiveStream();
        DataSource dsource = stream.getDataSource();
        newplayer = Manager.createPlayer(dsource);
      } catch (Exception e) {}

      if (newplayer == null) {
        return;
      } 

      if (source == videosm) {
        if (videoplayer == null) {
          videoplayer = newplayer;
          newplayer.addControllerListener(this);
          newplayer.start();
        } 
      }

      if (source == audiosm) {
        if (audioplayer == null) {
          audioplayer = newplayer;
          newplayer.addControllerListener(this);
          newplayer.start();
        } 
      } 
    } 
  }
  
  public synchronized void controllerUpdate(ControllerEvent evenement) {
    Player player = null;
    Controller controller = (Controller) evenement.getSource();
    if (controller instanceof Player) {
      player = (Player) evenement.getSource();
    } 
    if (player == null) {
      return;

    } 
    if (evenement instanceof RealizeCompleteEvent) {
      if ((composantVisuel = player.getVisualComponent()) != null) {
        largeur = composantVisuel.getPreferredSize().width;
        hauteur = composantVisuel.getPreferredSize().height;
      } 
      add(composantVisuel);
    } 
  }
  
  public SessionManager createSessionManager(String destaddrstr, 
                                             int port) {
    SessionManager sessionmgr = new RTPSessionMgr();
    if (sessionmgr == null) {
      return null;
    } 
    sessionmgr.addReceiveStreamListener(this);
    String cname = sessionmgr.generateCNAME();
    String nomUtilisateur = "jmf-wrox";
    SessionAddress localaddr = new SessionAddress();
    try {
      destaddr = InetAddress.getByName(destaddrstr);
    } catch (Exception e) {}
    SessionAddress sessaddr = new SessionAddress(destaddr, port, 
            destaddr, port + 1);

    SourceDescription[] userdesclist = new SourceDescription[2];

    userdesclist[0] = 
      new SourceDescription(SourceDescription.SOURCE_DESC_NAME, 
                            nomUtilisateur, 1, false);
    userdesclist[1] = 
      new SourceDescription(SourceDescription.SOURCE_DESC_CNAME, 
                            cname, 1, false);
    try {
      sessionmgr.initSession(localaddr, sessionmgr.generateSSRC(), 
                             userdesclist, 0.05, 0.25);
      sessionmgr.startSession(sessaddr, 1, null);
    } catch (Exception e) {
      return null;
    } 
    return sessionmgr;
  }
  
  public void stop() {
    if (videoplayer != null) {
      videoplayer.close();
    } 
    if (audioplayer != null) {
      audioplayer.close();
    } 
  }
  
    public void destroy() {
			String raison = "Fini.";
    if (videosm != null) {
      videosm.closeSession(raison);
      videoplayer = null;
      videosm = null;
    } 

    if (audiosm != null) {
      audiosm.closeSession(raison);
      audioplayer = null;
      audiosm = null;
    } 
    super.destroy();
  } 
}
// Fin de RTPMediaApplet.java