package com.wrox.projsp.ch18;

// Dbut de RTPTransmit.java
import java.awt.Dimension;
import javax.media.*;
import javax.media.rtp.*;
import javax.media.rtp.event.*;
import javax.media.protocol.*;
import javax.media.format.*;
import javax.media.control.TrackControl;
import java.io.*;
import java.awt.*;
import javax.media.rtp.rtcp.SourceDescription; 
import java.net.InetAddress; 
import com.sun.media.rtp.RTPSessionMgr;

public class RTPTransmit implements SendStreamListener {
  MediaLocator locator;
  String ipAddress;
  InetAddress ip;
  int port;
  Processor processor = null;
  DataSink rtptransmitter = null;
  DataSource dataout = null;
  int nbPiste = 0;
  int timeout = 1000;
  InetAddress destaddr;
  String adresse;
  String[] media;
  SessionManager[] sm;
  SendStream[] ss;
  int largeur = 0;
  int hauteur = 0;

    public RTPTransmit() {}

  public void setLocator(String loc) {
    locator = new MediaLocator(loc);
  } 

  public void setIPAddress(String addr) {
    adresse = addr;
  } 

  public void setPort(int prt) {
    port = prt;
  } 

  public int getLargeur() {
    return largeur;
  } 

  public int getHauteur() {
    return hauteur;
  }
  
    public synchronized String init() {
    String resultat;
    resultat = creerProcessor();
    if (resultat != null) {
	    System.out.println("Init : resultat creerProcessor!= null");
      return resultat;
    } 
    if (processor == null) System.out.println("Processor nul");
    resultat = creerTransmission();
    if (resultat == null) {
    	System.out.println("Init : resultat creerTransmission!= null");
      processor.close();
      processor = null;
      System.out.println("On ferme processor");
      return resultat;
    } 
    return null;
  }
  
  public String creerProcessor() {
  	System.out.println("Debut de creerProcessor");
    if (locator == null) {
      return "Rien de trouv.";
    } 
    try {
      processor = Manager.createProcessor(locator);
    } catch (Exception e) {
      return e.getMessage();
    } 
    if (processor != null) System.out.println("RTPTransmit : processor cre");
    System.out.println("On va appeler configure");
    processor.configure();
    int t;
    for (t = 0; t < timeout; t++) {
      if (processor.getState() == Processor.Configured) {
        break;
      } 
      try {
        Thread.currentThread().sleep(100);
      } catch (Exception e) {}
    } 
    if (t == timeout) {
      System.out.println("Erreur de configuration");
    } 
    System.out.println("Configuration = " + t);
    
    TrackControl[] pistes = processor.getTrackControls();

    if (pistes == null || pistes.length < 1) {
      return "Aucune piste dans le processor";
    } 

    Format[] format = new Format[pistes.length];
    media = new String[pistes.length];

    for (int i = 0; i < pistes.length; i++) {
      format[i] = pistes[i].getFormat();
      System.out.println(pistes[i].getFormat());
      if (pistes[i].isEnabled()) {
        if (format[i] instanceof VideoFormat) {
          media[i] = "video";
          System.out.println("Format video");
          Format[] supported = pistes[i].getSupportedFormats();


          Dimension size = ((VideoFormat) format[i]).getSize();
          largeur = (int) size.getWidth();
          hauteur = (int) size.getHeight();
          float frameRate = ((VideoFormat) format[i]).getFrameRate();
          VideoFormat jpegFormat = 
            new VideoFormat(VideoFormat.JPEG_RTP, size, 
                            Format.NOT_SPECIFIED, Format.byteArray, 
                            frameRate);
  
  				Format formatChoisi = verifierTailleVideo(pistes[i].getFormat() , supported[0]);
  				pistes[i].setFormat(formatChoisi);                   
  				                          
          if (pistes[i].setFormat(formatChoisi) != null) {
            nbPiste++;
          } 
        } else if (format[i] instanceof AudioFormat) {
        	System.out.println("Format audio");
          media[i] = "audio";
          AudioFormat af = (AudioFormat) format[i];
          AudioFormat mpegFormat = 
            new AudioFormat(AudioFormat.MPEG_RTP);
          if (pistes[i].setFormat(mpegFormat) != null) {
            nbPiste++;
          } 
        } 
      } 
    } 
    System.out.println("Nombre de pistes = " + nbPiste);
    
    ContentDescriptor cd = 
      new ContentDescriptor(ContentDescriptor.RAW);
    processor.setContentDescriptor(cd);
    processor.realize();

    for (t = 0; t < timeout; t++) {
      if (processor.getState() == Controller.Realized) {
        break;
      } 
      try {
        Thread.currentThread().sleep(100);
      } catch (InterruptedException ie) {}
    } 
    System.out.println("Realizing = " + t);
    if (t == timeout) {
      System.out.println("Erreur de realizing");
    } 
    dataout = processor.getDataOutput();
    System.out.println("Dataout n'est pas nul");
    return null;
  }
  
  
  Format verifierTailleVideo(Format original, Format supported) {

	int width, height;
	Dimension size = ((VideoFormat)original).getSize();
	Format jpegFmt = new Format(VideoFormat.JPEG_RTP);
	Format h263Fmt = new Format(VideoFormat.H263_RTP);

	if (supported.matches(jpegFmt)) {
	    // Pour JPEG, etre sur que hauteur et largeur soit divisible par 8
	     width = (size.width % 8 == 0 ? size.width :
				(int)(size.width / 8) * 8);
	    height = (size.height % 8 == 0 ? size.height :
				(int)(size.height / 8) * 8);
	} else if (supported.matches(h263Fmt)) {
	    // For H.263, on supporte quelques tailles spcifiques
	 if (size.width < 128) {
		width = 128;
		height = 96;
	    } else if (size.width < 176) {
		width = 176;
		height = 144;
	    } else {
		width = 352;
		height = 288;
	    }
	} else {
	    
	    return supported;
	}

	return (new VideoFormat(null, 
				new Dimension(width, height), 
				Format.NOT_SPECIFIED,
				null,
				Format.NOT_SPECIFIED)).intersects(supported);
    }
  
  
  public long getDuration() {
    if (processor != null) {
      Time time = processor.getDuration();
      if (time == Duration.DURATION_UNKNOWN) {
        return 0;
      } 
      return time.getNanoseconds() / 1000000;
    } else {
      return -1;
    }
  }
  
  public String creerTransmission() {
    sm = new SessionManager[nbPiste];
    ss = new SendStream[nbPiste];

    for (int i = 0; i < nbPiste; i++) {
      sm[i] = createSessionManager(adresse, port + 2 * i);

      System.out.println("SM " + i + "  Media = " + media[i]);
      System.out.println("Adresse = " + adresse + "  Port = " + port 
                         + 2 * i);
      try {
        ss[i] = sm[i].createSendStream(dataout, i);
        System.out.println("Creer send stream ok pour "+i);
      } catch (Exception e) {
        return "Erreur createSendStream =" + e.getMessage();
      } 
    } 
    return null;
  }
  
   public String transmit() {
    processor.start();
    System.out.println("Processor lanc");
    for (int i = 0; i < nbPiste; i++) {
      try {
        ss[i].start();
        System.out.println("ss[" + i + "] dmarr");
      } catch (Exception e) {
        return e.getMessage();
      } 
    } 
    return null;
  }
  
  public void update(SendStreamEvent evenement) {
    SessionManager source = (SessionManager) evenement.getSource();
  }
  
  public SessionManager createSessionManager(String destaddrstr, 
                                             int port) {
    SessionManager sessionmgr = new RTPSessionMgr();
    if (sessionmgr == null) {
      return null;
    } 
    sessionmgr.addSendStreamListener(this);
    String cname = sessionmgr.generateCNAME();
    String nomUtilisateur = "jmf-wrox";
    SessionAddress localaddr = new SessionAddress();
    try {
      destaddr = InetAddress.getByName(destaddrstr);
    } catch (Exception e) {}
    SessionAddress sessaddr = new SessionAddress(destaddr, port, 
            destaddr, port + 1);

    SourceDescription[] userdesclist = new SourceDescription[2];

    userdesclist[0] = 
      new SourceDescription(SourceDescription.SOURCE_DESC_NAME, 
                            nomUtilisateur, 1, false);
    userdesclist[1] = 
      new SourceDescription(SourceDescription.SOURCE_DESC_CNAME, 
                            cname, 1, false);
    try {
      sessionmgr.initSession(localaddr, sessionmgr.generateSSRC(), 
                             userdesclist, 0.05, 0.25);
      sessionmgr.startSession(sessaddr, 1, null);
    } catch (Exception e) {
      return null;
    } 
    return sessionmgr;
  }
  
   public synchronized void stop() {
    if (processor != null) {
      System.out.println("Processor arrt");
      processor.stop();
      processor.close();
      processor = null;
      destroy();
    } 
  } 

  public void destroy() {
    for (int i = 0; i < nbPiste; i++) {
      if (sm[i] != null) {
        sm[i].closeSession("Termin.");
        sm[i] = null;
      } 
    } 
  } 
}   // Fin de RTPTransmit.java