package com.wrox.projsp.ch19;
import java.util.*;
import java.sql.*;

public class DBConnectionManager extends Cache { 

static private PropertyGroups pG;
static private Hashtable drivers;

static Logger errLg,adminLg;

static String dbUtilisateur=null,dbMotDePasse=null,dbUrl=null; 
static int dbTimeout=100,dbInitSize=2,dbMaxSize=3;

protected DBConnectionManager()throws Exception{
  pG=new PropertyGroups("/com/wrox/projsp/ch19/DBConnMgr.properties");
  adminLg=new Logger(pG.getProperty("admin.log","DBadmin.log"));
  errLg=new Logger(pG.getProperty("err.log","DBerr.log"));
  dbUrl=pG.getProperty("dbUrl",dbUrl); 
  dbUtilisateur=pG.getProperty("dbUtilisateur",dbUtilisateur);
  dbMotDePasse=pG.getProperty("dbMotDePasse",dbMotDePasse);
  dbTimeout=topIntProp("dbTimeout",dbTimeout);
  dbMaxSize=topIntProp("dbMaxSize",dbMaxSize);
  dbInitSize=topIntProp("dbInitSize",dbInitSize);
  initDrivers(pG.getProperties("driver"));
  Enumeration pools=pG.propertyKeys();
  while(pools.hasMoreElements()){
    String nom=(String)pools.nextElement();
    if(!"driver".equals(nom))
      initPool(nom,pG.getProperties(nom));
    }
}

public void addDriver(String nom)throws Exception{
  if(null==nom || nom.length()==0 || null!=drivers.get(nom))return;
  try{
    Driver driver=(Driver)Class.forName(nom).newInstance();
    DriverManager.registerDriver(driver);
    drivers.put(nom,driver);
    adminLg.logIt("Driver JDBC enregistr: "+nom);
  }catch(Exception ex){
    errLg.logIt("Impossible d'enregistrer le driver JDBC: "+nom);
    throw new Exception("Impossible d'enregistrer le driver JDBC: "+nom);
  }
}

protected void initDrivers(Properties drivernames)throws Exception{
  drivers=new Hashtable();
  Enumeration names=drivernames.keys();
  while(names.hasMoreElements())
    addDriver((String)names.nextElement());
}
    

private int topIntProp(String key,int def)throws Exception{
  String S=pG.getProperty(key);
  if(null==S)return def;
  return intKey(key,S);
}

private int intKey(String key,String intStr)throws Exception{
  try{return Integer.parseInt(intStr);}
  catch(Exception ex){
    String msg="DBConnectionManager: cle "+key+"='"+intStr+"'";
    errLg.logIt(msg);
    throw new Exception(msg);
    }
}
private int getInt(Properties p,String key,int def)throws Exception{
  int R=def; 
  String S=p.getProperty(key,pG.getProperty(key));
  if(null!=S)return intKey(key,S);
  return R;
}

private void initPool(String poolName,Properties props)
     throws Exception{
  String url=props.getProperty("dbUrl",dbUrl);
  if(null==url || url.length()==0){
    String msg="Aucun pool de connexion pour "+poolName+" in "+props;
    errLg.logIt(msg);
    throw new Exception(msg);
    }
  String usr=props.getProperty("dbUtilisateur",dbUtilisateur);
  String pwd=props.getProperty("dbMotDePasse",dbMotDePasse);
  int timeout=getInt(props,"dbTimeout",dbTimeout);
  int maxSize=getInt(props,"dbMaxSize",dbMaxSize);
  int initSize=getInt(props,"dbInitSize",dbInitSize);
  DBConnectionPool cP=
    new DBConnectionPool(url+"--"+usr,url,usr,pwd,timeout,initSize,maxSize,
                          errLg,adminLg);
  put(url,usr,pwd,cP);
  adminLg.logIt("pool cre "+poolName+" pour "+url+"--"+usr+" "+
                    new java.util.Date());
}

public DBConnectionPool getConnectionPool(String url,
                        String usr,String pwd)throws Exception{
  if(null==url || url.length()==0)url=dbUrl;
  if(null==url || url.length()==0)
    throw new Exception("aucune dbUrl pour le ppol de connexion");


  DBConnectionPool cP=(DBConnectionPool)get(url,usr,pwd);
  if(null!=cP)adminLg.logIt("pool retrouv pour "+url+"--"+usr);
  if(null!=cP)return cP;
  cP=new DBConnectionPool(url+"--"+usr,url,usr,pwd,
                          dbTimeout,dbInitSize,dbMaxSize,
                          errLg,adminLg);
  put(url,usr,pwd,cP);
  adminLg.logIt("pool cre "+url+"--"+usr+" "+new java.util.Date());
  return cP;
}

public boolean freeItem(Object ob){ 
  if(!(ob instanceof DBConnectionPool)){
    errLg.logIt("aucun pool de connexion dans le cache db"+ob);
    return false;
    }
  DBConnectionPool cP=(DBConnectionPool)ob;
  cP.close();
  return true;
}

protected class Authorization { 
  String url,usr,pwd;
  public Authorization(String a,String b,String c){url=a;usr=b;pwd=c;}
}


protected class PasswordManager {
  Connection pwdConnection=null; 
  PreparedStatement groupPwd=null;
  final String queryStr="SELECT groupUrl,groupUsr,groupPwd "
              + " FROM PASSWORDS WHERE url=? AND usr=? and pwd=?";
  Authorization auth;
  boolean passAlong; 

  public PasswordManager(String url,String usr,String pwd,boolean pass)
      throws Exception{
    passAlong=pass;
    auth = new Authorization(url,usr,pwd);
    pwdConnection= DriverManager.getConnection(url,usr,pwd);
    groupPwd=pwdConnection.prepareStatement(queryStr);
 }
  public Authorization checkPassword(String url,String usr,String pwd)
     throws Exception{
      groupPwd.setString(1,url);
      groupPwd.setString(2,usr);
      groupPwd.setString(3,pwd);
      ResultSet rs=groupPwd.executeQuery();
      if(!rs.next()){
         rs.close(); 
         if(passAlong)return new Authorization(url,usr,pwd);
         else return new Authorization(url,"","");
         }
      Authorization auth
        =new Authorization(rs.getString(1),rs.getString(2),rs.getString(3));
      rs.close();
      return auth;
}

}



private static Cache instance=null; 
private static int clients=0;       

protected void init(){super.init();}  
 
public static synchronized Cache getInstance(){ 
  try{
    if(null==instance)instance=new DBConnectionManager();
    clients++;
    adminLg.logIt("instance de ConnectionManager ajout");
    return instance;
  }catch(Exception ex){ex.printStackTrace(); return null;}
}

public static synchronized int freeInstance(){ 
  if(null==instance)return 0;
  clients--;
adminLg.logIt("instance de ConnectionManager quitt "+clients);
  if(clients==0)
     try{close(); 
     adminLg.logIt("manager de connexion ferm");
     }catch(Exception ex){errLg.logIt("liberation instance ",ex);}
  return clients;
}

public static synchronized boolean close()throws Exception{ 
  clients=0;
  while(0==instance.freeSpace(10000)); 
  instance=null;
  Enumeration enum=drivers.keys();
  while(enum.hasMoreElements()){
    String key=(String)enum.nextElement();
    try{
      DriverManager.deregisterDriver((Driver)drivers.get(key));
      adminLg.logIt("driver desenregistr "+key);
    }catch(Exception ex){
      String msg="echec pour desenregistrer le driver "+key;
      errLg.logIt(msg);
      throw new Exception(msg); 
    }
  }
  return true;

}



}