package com.wrox.projsp.ch19;

import java.util.Date;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.DriverManager;

public class DBConnectionPool{
  int maxSize; int initSize; int inUse; int timeout;
  String poolName; String dbUrl; String dbUser; String dbPwd;
  Queue Q; Logger errLg; Logger adminLg;

public DBConnectionPool
  (String nm,String url,String utilisateur,String motDePasse,
           int timeout,int initSize,int maxSize,
         Logger er,Logger adm) throws Exception{
  poolName=nm; dbUrl=url; dbUser=utilisateur; dbPwd=motDePasse; 
  if(null==dbUser)dbUser="";
  if(null==dbPwd)dbPwd="";
  this.maxSize=maxSize; this.initSize=initSize; this.timeout=timeout;
  errLg=er; adminLg=adm;
  Q=new Queue(); inUse=0;
  adminLg.logIt("DBConnectionPool initialisation pour "+poolName);
  preload(initSize);
}

public synchronized Connection popConnection(){
  while(!Q.isEmpty()){
    try{
      Connection con=(Connection)Q.next();
      if(!con.isClosed())return con; 
      adminLg.logIt("REJECT: connexion dans "+poolName+" a t ferm");
      }catch(Exception ex){
        errLg.logIt("DBConnectionPool.popConnection: ",ex);
      }
   }
  return null;
}

public synchronized Connection getConnection(){
  Connection con=popConnection();
  if(null==con)
    if(maxSize<0 || inUse<maxSize)
      con=newConnection();
  if(null!=con)inUse++;
  return con;
}

public synchronized void close(){
  Connection con;
  while(!Q.isEmpty()){
   if(null==(con=popConnection()))continue;
   try{
     con.close();
    adminLg.logIt("connexion ferme dans pool "+poolName);
   }catch(SQLException ex){errLg.logIt("erreur dans fermeture "+poolName,ex);}
  }
  if(inUse>0)
    errLg.logIt("fermeture "+poolName+" avec "+inUse+" encore connecte");
  else adminLg.logIt("ferme "+poolName);
}
public void preload(int N)throws Exception {
  for(int i=0;i<N;i++){
    Connection con=newConnection();
    if(null==con)throw new Exception("echec de connexion dans "+dbUrl);
    Q.append(con);
    }
}

public synchronized void freeConnection(Connection con){
  Q.append(con);
  inUse--;
  notifyAll(); 
}

private Connection newConnection(){
  adminLg.logIt("nouvelle connexion pour "+poolName+"; "+dbUser+"; "+dbPwd);
  try{
    if(dbUser.length()==0)
       return DriverManager.getConnection(dbUrl);
    else return DriverManager.getConnection(dbUrl,dbUser,dbPwd);
  }catch(SQLException ex){
     errLg.logIt("aucune nouvelle connexion pour "+dbUrl,ex);
     return null;
  }
}

public Connection getConnection(int timeout){
  long waitUntil=new Date().getTime()+timeout;
  Connection con;
  while(null==(con=getConnection()) && waitUntil > new Date().getTime()){
    try{wait(timeout);}catch(InterruptedException ex){}
    }
  return con;
}
public Connection getConnWait(){
  return getConnection(timeout);
}
}