package com.wrox.projsp.ch19;

import java.util.Hashtable;
import java.sql.Date;
import java.text.DateFormat;
import java.util.Enumeration;
import java.sql.*;   

public class DBHandler  { 
  DBConnectionManager dbCM=null; //Cache
   DBConnectionPool dbCP=null;    // Pool connection 
  Connection connection=null; 
  static String defaultDateFormat="yyyy-MM-dd"; 
  String dateFormat=null; 
  java.text.SimpleDateFormat simpleDateFormat; 

  Hashtable requetes=null; 
  String opCourant=null;
  String nomDriver=null; // ="sun.jdbc.odbc.JdbcOdbcDriver";
  String dbUrl=null;  // ="jdbc:odbc:METEO";
  String utilisateur=null; 
  String motDePasse=null; 
  Logger lg;
  public DBHandler(String dbDriver,String dbNom,
                   String dbUtilisateur,String dbMotDePasse,
                   String [] qNoms,String [] qVals)
                     throws SQLException{
    lg=new Logger();
    initDBHandler(dbDriver,dbNom,dbUtilisateur,dbMotDePasse,qNoms,qVals,null);
  }
  public DBHandler(String dbDriver,String dbNom,
                   String dbUtilisateur,String dbMotDePasse,
                   String [] qNoms,String [] qVals,
                   String [] qTypes)
                     throws SQLException{
   lg=new Logger();
    initDBHandler(dbDriver,dbNom,dbUtilisateur,dbMotDePasse,qNoms,qVals,qTypes);
  }
  public DBHandler(Dict env)throws SQLException,Exception{
    lg=new Logger(); //XXXX
    String dbDriver=env.getDef("dbDriver","sun.jdbc.odbc.JdbcOdbcDriver");
    String dbNom=env.getDef("dbNom","jdbc:odbc:DEFAULTDB");
    String dbUtilisateur=env.getDef("dbUtilisateur","");
    String dbMotDePasse=env.getDef("dbMotDePasse","");
    String dbRequetes=env.getDef("dbRequetes"); 
    dateFormat=env.getDef("dbDateFormat",defaultDateFormat);
    String [] qNoms=Misc.stringSplit(dbRequetes,',');
    String [] qVals=new String[qNoms.length];
    String [] qTypes=new String[qNoms.length];
    for(int i=0;i<qVals.length;i++){
      qVals[i]=env.getDef(qNoms[i]);
      qTypes[i]=env.getDef(qNoms[i]+"_types");
      }
    initDBHandler(dbDriver,dbNom,dbUtilisateur,dbMotDePasse,qNoms,qVals,qTypes);
    }
public void setDateFormat(String newFormat){
  if(newFormat==null)return;
  newFormat=newFormat.trim();
  if(newFormat.length()==0) return;
  dateFormat=newFormat;
  simpleDateFormat=new java.text.SimpleDateFormat(dateFormat); //default locale
}

protected Connection checkConnection()throws SQLException{
  if(null!=connection)return connection;
  try{
  if(null==dbCM)dbCM=(DBConnectionManager)DBConnectionManager.getInstance(); 
  dbCM.addDriver(nomDriver); 
  if(null==dbCP)dbCP=dbCM.getConnectionPool(dbUrl,utilisateur,motDePasse);
  connection=dbCP.getConnection();
  if(null==connection)
    throw new SQLException(dbUrl+", driver "+nomDriver + " null");
  lg.logIt("DBHandler obtient connexion "+dbUrl+", "+utilisateur);
  return connection;
  }catch(Exception ex){
   lg.logIt("DBHandler.verifie connexion "+dbUrl+": "+ex);
   throw new SQLException(dbUrl+", driver "+nomDriver+
                          " echoue pour la connexion "+ex);
  }
}
protected void freeConnection(){ // appel sur close.
  if(null==connection)return;
  dbCP.freeConnection(connection);
lg.logIt("DBHandler libre la connexion pour "+dbUrl+", "+utilisateur);
  connection=null;
}

  public void initDBHandler(String dbDriver,String dbNom,
                   String dbUtilisateur,String dbMotDePasse,
                   String [] qNoms,String [] qVals,String[] qTypes)
                     throws SQLException{
    nomDriver=dbDriver; 
    dbUrl=dbNom;
    utilisateur=dbUtilisateur;
    motDePasse=dbMotDePasse;
    requetes=new Hashtable();
    if(null==dateFormat || dateFormat.length()==0)
      dateFormat=defaultDateFormat;
   try{
lg.logIt("nomDriver="+nomDriver+"\ndbUrl="+dbUrl+"\nutilisateur="+utilisateur+"\nmotDePasse="+motDePasse);
     checkConnection();
     if(qTypes==null)qTypes=new String[qVals.length];
     for(int i=0;i<qNoms.length;i++)
       requetes.put(qNoms[i].toUpperCase(),
                      new Requete(qNoms[i],qVals[i].trim(),qTypes[i]));  
     simpleDateFormat=new java.text.SimpleDateFormat(dateFormat); //default locale
     }catch(Exception ex){ex.printStackTrace(); lg.logIt("DBHandler echoue ",ex);}
  }
  public DBHandler(String qSpecStr)throws SQLException{  
   lg=new Logger();
   requetes=new Hashtable();
   String[]S=Misc.stringSplit(qSpecStr);
   String[][]qSpec=new String[S.length][];
   for(int i=0;i<S.length;i++)qSpec[i]=Misc.stringSplit(S[i]);
   nomDriver=qSpec[0][0]; dbUrl=qSpec[0][1];
   utilisateur=qSpec[0][2]; motDePasse=qSpec[0][3];             
lg.logIt("nomDriver="+nomDriver+"\ndbUrl="+dbUrl+"\nutilisateur="+utilisateur+"\nmotDePasse="+motDePasse);
   try{
     checkConnection();
     for(int i=1;i<qSpec.length;i++)
       requetes.put(qSpec[i][0].toUpperCase(),new Requete(qSpec[i]));  
    }catch(Exception ex){ex.printStackTrace();lg.logIt("DBHandler echoue",ex);}
  }

  public String[][] getQueryStringMatrix(Dict qInfo)throws SQLException{
   try{
    opCourant=qInfo.getDef("requete").toUpperCase();
    if(""==opCourant)throw new SQLException("aucune requete db dfinie dans "+qInfo.toString());
    Requete Q=(Requete)requetes.get(opCourant);
    if(null==Q)throw new SQLException("aucune requete preparee dans "+opCourant);
    return Q.getQueryStringMatrix(qInfo);
   }catch(SQLException ex){dbCM.freeInstance(); throw(ex);}
  }

  public ResultatRequete getResultatRequete(Dict qInfo)throws SQLException{
   try{
   	System.out.println("getResultatRequete : debut");
   	opCourant=qInfo.getDef("requete").toUpperCase();
   	System.out.println("on recherche "+opCourant);
    if(""==opCourant)throw new SQLException("aucune requete db dfinie dans "+qInfo.toString());
    Requete Q=(Requete)requetes.get(opCourant);
    System.out.println("as t'on recupere");

    if(null==Q)throw new SQLException("aucune requete preparee dans  "+opCourant);
    return Q.getResultatRequete(qInfo);
   }catch(SQLException ex){dbCM.freeInstance(); throw(ex);}
  }
  public ResultatRequete getResultatRequete(String op,String[] args)throws SQLException{
   try{
    if(op==null || op.length()==0)
      throw new SQLException("aucune requete db dfinie dans ["+Misc.stringArrayJoin(args,",")+"]");
    Requete Q=(Requete)requetes.get(op.toUpperCase());
    if(null==Q)throw new SQLException("aucune requete preparee dans  "+op);
    return Q.getResultatRequete(args);
   }catch(SQLException ex){dbCM.freeInstance(); throw(ex);}
  }
  public ResultatRequete getResultatRequete(String op)throws SQLException{
    return getResultatRequete(op, new String[]{});
  }
  public ResultatRequete getResultatRequete(String opCourant,String QP1)throws SQLException{
    return getResultatRequete(opCourant, new String[]{QP1});
  }
  public ResultatRequete getResultatRequete(String opCourant,
       String QP1,String QP2)throws SQLException{
    return getResultatRequete(opCourant, new String[]{QP1,QP2});
  }
  public ResultatRequete getResultatRequete(String opCourant,
       String QP1,String QP2,String QP3)throws SQLException{
    return getResultatRequete(opCourant, new String[]{QP1,QP2,QP3});
  }
  public ResultatRequete getResultatRequete(String opCourant,
       String QP1,String QP2,String QP3,String QP4)throws SQLException{
    return getResultatRequete(opCourant, new String[]{QP1,QP2,QP3,QP4});
  }
  public ResultatRequete getResultatRequete(String opCourant,
       String QP1,String QP2,String QP3,String QP4,String QP5)throws SQLException{
    return getResultatRequete(opCourant, new String[]{QP1,QP2,QP3,QP4,QP5});
  }
  public void gotoSleep()throws SQLException{ 
   Enumeration qq=requetes.elements();
   while(qq.hasMoreElements()){
     Requete Q=(Requete)qq.nextElement();
     if(null!=Q)Q.close();
     }
   freeConnection();
  }
  public void close()throws SQLException{ 
   gotoSleep();
   dbCM.freeInstance();
   dbCP=null;
   dbCM=null;
  }

  public void ajouterRequete(String qNm,String qStr,String qT)
             throws SQLException{
     requetes.put(qNm.toUpperCase(),new Requete(qNm,qStr,qT));  
  }
  public void effacerRequete(String qNm)throws SQLException{
     Requete Q=(Requete)requetes.get(qNm=qNm.toUpperCase());
     if(null==Q)return;
     Q.close();
     requetes.remove(qNm);  
  }

private class Requete {
  public String qNom; 
  public String qString; 
  public String[]qTypes;
  public PreparedStatement pStmnt=null;
  public int argCount; public int colCount;
  ResultSet resultat=null;
  public void close()throws SQLException{
    if(null!=resultat)resultat.close(); 
    resultat=null;
    if(null!=pStmnt)pStmnt.close();
    pStmnt=null;
  }
  public Requete(String [] Q)throws SQLException{this(Q[0],Q[1],Q[3]);}

  public Requete(String qNm, String qStr,String qT) throws SQLException{
     qNom=qNm; qString=qStr; 
     if(null==qT)qT="";
     qTypes=Misc.stringSplit(qT,',');
     argCount=0;for(int i=0;i<qStr.length();i++)if(qStr.charAt(i)=='?')argCount++;
     colCount=0;
  }

  private PreparedStatement checkPstmnt() throws SQLException{
  	System.out.println("On execute "+qString);
    if(null==pStmnt)pStmnt=checkConnection().prepareStatement(qString);
    return pStmnt;
  }

  public String[][] getQueryStringMatrix(Dict qInfo) throws SQLException{
  checkPstmnt();
  for(int i=1;i<=argCount;i++)setParamStr(i,qInfo.getDef("QP"+i,""));
  if(pStmnt.execute()){lg.logIt("c'est un resultset");
    return MiscDB.resultRowsToStringMatrix(pStmnt.getResultSet());
    }
  else { lg.logIt("ce n'est pas un resultset");
    String[][]res=new String[][]{{"NombreDeLigneAffectes"},{""+pStmnt.getUpdateCount()}};
    return res;
    }
  }
  
  
  public ResultatRequete getResultatRequete(Dict qInfo) throws SQLException{
 try{
 	System.out.println("Requete : getResultatRequete");
  checkPstmnt();
  for(int i=1;i<=argCount;i++)setParamStr(i,qInfo.getDef("QP"+i,""));
  if(pStmnt.execute()){
    return new ResultatRequeteTable(qNom,pStmnt.getResultSet());
    }
  else { int numberAffected=pStmnt.getUpdateCount();
    String[]colLabels=new String[]{"NombreDeLigneAffectes"};
    String[]colTypes=new String[]{"TEXT"};
    String[][]rows=new String[][]{{""+numberAffected}};
lg.logIt("returning "+numberAffected);
    return new ResultatRequeteTable(qNom,colLabels,colTypes,rows);
    }
 }catch(SQLException ex){lg.logIt("getResultatRequete",ex); throw(ex);}
  }
  
  
  public ResultatRequete getResultatRequete(String[]args) throws SQLException{
 try{
  checkPstmnt();
  for(int i=1;i<=argCount;i++)setParamStr(i,args.length<=i?"":args[i-1]);
  if(pStmnt.execute()){
    return new ResultatRequeteTable(qNom,pStmnt.getResultSet());
    }
  else { int numberAffected=pStmnt.getUpdateCount();
    String[]colLabels=new String[]{"NombreDeLigneAffectes"};
    String[]colTypes=new String[]{"TEXT"};
    String[][]rows=new String[][]{{""+numberAffected}};
lg.logIt("returning "+numberAffected);
    return new ResultatRequeteTable(qNom,colLabels,colTypes,rows);
    }
 }catch(SQLException ex){lg.logIt("getResultatRequete",ex); throw(ex);}
  }

  public void setParamStr(int i,String val)throws SQLException{
   String t=(i>qTypes.length)?null:qTypes[i-1];
lg.logIt("setParamStr("+i+","+val+") of type "+t);
    try{
    if(t==null || t.length()==0 ||"text".equalsIgnoreCase(t)
     ||"varchar".equalsIgnoreCase(t)||"longvarchar".equalsIgnoreCase(t))
      pStmnt.setString(i,val);
    else if(t.equalsIgnoreCase("date")){
       java.util.Date d=simpleDateFormat.parse(val);
      java.sql.Date dbdate=new java.sql.Date(d.getTime());
      pStmnt.setDate(i,dbdate);
      }
    else if( t.equalsIgnoreCase("datetime")
            || t.equalsIgnoreCase("timestamp")){
      java.util.Date d=simpleDateFormat.parse(val);
      java.sql.Timestamp dbdate=new java.sql.Timestamp(d.getTime());
      pStmnt.setTimestamp(i,dbdate);
      }
    else if(t.equalsIgnoreCase("time")){
      java.util.Date d=simpleDateFormat.parse(val);
      java.sql.Time dbdate=new java.sql.Time(d.getTime());
      pStmnt.setTime(i,dbdate);
      }
    else if(t.equalsIgnoreCase("int")){
      int intVal=Integer.parseInt(val);
      pStmnt.setInt(i,intVal);
      }
    else pStmnt.setString(i,val);
   }catch(java.text.ParseException e){
     throw new SQLException("setParamStr echoue pour le parse de ["+val+"]  ["+t+":"+e);
   }catch(java.lang.NumberFormatException e){
     throw new SQLException("setParamStr  echoue pour le parse de ["+val+"]   ["+t+":"+e);
   }
  }

}

}