import java.io.*;
import org.xml.sax.*;
import org.xml.sax.helpers.ParserFactory;
import com.sun.xml.parser.Resolver;

public class Echo01 extends HandlerBase 
{
 public static void main (String argv [])
 throws IOException
 {
 InputSource input;
 if (argv.length != 1) {
  System.err.println ("Utilisation : commande nomfichier");
  System.exit (1);
 }

 try {
  // Dfinir le flot de sortie
  out = new OutputStreamWriter (System.out, "UTF-8");

  // Transformer le fichier d'entre XML en un objet XML "entre source"
  input = Resolver.createInputSource (new File (argv [0]));

  // Obtenir une instance du parseur non-validant.
  Parser parser;
  parser = ParserFactory.makeParser ("com.sun.xml.parser.Parser");
  parser.setDocumentHandler ( new Echo01() );   
// analyse l'entre source
  parser.parse (input);  

  } catch (Throwable t) {
   t.printStackTrace ();
  }
  System.exit (0);
 }
 static private Writer	out;
//===========================================================
 // SAX DocumentHandler methods
 //=========================================================== 

 public void startDocument ()
 throws SAXException
 {  
  emit ("<?xml version='1.0' encoding='UTF-8'?>");  
  nl();  
 }

 public void endDocument ()
 throws SAXException
 {  
  try {
   nl();
   out.flush ();
  } catch (IOException e) {
   throw new SAXException ("I/O error", e);
  }
 }

 public void startElement (String nom, AttributeList attrs)
 throws SAXException
 {  
  emit ("<"+nom);
  if (attrs != null) {
   for (int i = 0; i < attrs.getLength (); i++) {    
    emit (" ");
    emit (attrs.getName(i)+"=\""+attrs.getValue (i)+"\"");    
   }
  }  
  emit (">");
 }
}