package com.wrox.projsp.ch19;

import java.sql.*;
import java.util.Hashtable;
import java.util.Vector;
import java.io.*;


public class MiscDB {

public static Hashtable resultSetAsHashTable(ResultSet R)
        throws SQLException {
  Hashtable H=new Hashtable();
  if(R==null)return H;
  String[] fieldNames=resultSetLabels(R);
  return resultSetAsHashTable(fieldNames,R,H);
}


public static Hashtable resultSetAsHashTable(String [] cols,ResultSet R,
                                             Hashtable H)
        throws SQLException {
  if(R==null)return H;
  for (int i=1; i<=cols.length;i++)
    H.put(cols[i-1],R.getString(i));
  return H;
}

public static String [] resultSetLabels(ResultSet R)
         throws SQLException{
         	System.out.println("oN execute la recherche des noms de colonnes");
  ResultSetMetaData rsmd = R.getMetaData();
  String S []=new String[rsmd.getColumnCount()];
  for(int i=0;i<S.length;i++) {
  	S[i]=rsmd.getColumnLabel(i+1);
  	System.out.println("On a comme label "+S[i]);
  }
  return S;
}

public static int resultSetColumnCount(ResultSet R)
          throws SQLException{
  ResultSetMetaData rsmd = R.getMetaData();
  return rsmd.getColumnCount();
}

public static String [] resultSetTypes(ResultSet R)
          throws SQLException{
  ResultSetMetaData rsmd = R.getMetaData();
  String S []=new String[rsmd.getColumnCount()];
  for(int i=0;i<S.length;i++)S[i]=rsmd.getColumnTypeName(i+1);
  return S;
}

public static String [] resultRowValues(ResultSet R)
         throws SQLException{
  String S[]=new String[resultSetColumnCount(R)];
  for(int i=0;i<S.length;i++)S[i]=R.getString(i+1);
  return S;
}

 public static String[][] vectorToStringMatrix(Vector V){ 
    if(V==null || V.size()==0)return null;
    String [][]R=new String[V.size()][];
    for(int i=0;i<R.length;i++)R[i]=(String[])(V.elementAt(i));
    return R;
  }

  public static String[][] resultRowsToStringMatrix(ResultSet R){ 
    try{
      Vector V=new Vector(); 
      V.addElement(resultSetLabels(R)); 
      while(R.next())V.addElement(resultRowValues(R));
      R.close();
      return vectorToStringMatrix(V);
    }catch(SQLException E){E.printStackTrace();return null;}
  }
  public static String[][] resultRowsToRowMatrix(ResultSet R){ 
    try{
      Vector V=new Vector(); 
      while(R.next())V.addElement(resultRowValues(R));
      R.close();
      return vectorToStringMatrix(V);
    }catch(SQLException E){E.printStackTrace();return null;}
  }


public static String  createTable(Statement stmnt, String name,
                    String[]fldnames,String[]fldtypes,boolean doReset){
  String result="";
  try{
    int N=fldnames.length;
    String createStr="CREATE TABLE "+name+" (";
    if(N>0)createStr+=fldnames[0]+" "+fldtypes[0];
    for(int i=1;i<N;i++)createStr+=", "+fldnames[i]+" "+fldtypes[i];
    createStr+=")";
    result+="createStr="+createStr+"\n";
    try{stmnt.execute(createStr);
    }catch(SQLException e){
       StringWriter sw=new StringWriter();
       e.printStackTrace(new PrintWriter(sw));
       result+=sw.toString();
       }
    if(doReset){
      String delStr="DELETE * FROM "+name;
      stmnt.execute(delStr);
      }
   }catch(SQLException e){
     StringWriter sw=new StringWriter();
       e.printStackTrace(new PrintWriter(sw));
     result+=sw.toString();
     }
   return result;
}
public static PreparedStatement 
    createInserter(String name,String[]fldnames,Connection conn)
      throws SQLException {
    int N=fldnames.length;
    String insertStr="INSERT INTO "+name+" VALUES (";
    if(N>0)insertStr+="?";
    for(int i=1;i<N;i++)insertStr+=", ?";
    insertStr+=")";
    PreparedStatement pStmnt=conn.prepareStatement(insertStr);
    return pStmnt;
}

}