package com.wrox.projsp.ch19;

import java.util.*;


public class PropertyGroups extends Hashtable {

private Properties props=null; 
private String fileName=null; 
Logger lg;
int simpleKeys;
int compoundKeys;

public PropertyGroups(){
  props=new Properties(); 
  lg=new Logger();
  simpleKeys=0;
  compoundKeys=0;
}
   

public PropertyGroups(String name)throws Exception{
  this();
  load(name);
}

public void load(String name)throws Exception{fileName=name; load();}

public void load()throws Exception{
  java.io.InputStream is=getClass().getResourceAsStream(fileName);
  if(null==is) throw
     new Exception("PropertyGroups.load: can't get resource "+fileName);
  props.load(is);
  is.close();
  Enumeration keys=props.keys();
  while(keys.hasMoreElements()){
    String key=(String)keys.nextElement();
    int sloc;
    if(0>(sloc=key.indexOf('_'))){
       simpleKeys++;
       put(key,props.get(key));
       }
    else{
      String key1=key.substring(0,sloc);
      String key2=key.substring(1+sloc);
      Properties subprops=(Properties)get(key1);
      if(null==subprops){
          compoundKeys++;
          put(key1,subprops=new Properties());
          }
      subprops.put(key2,props.get(key));
      }
    }
}

public String getProperty(String key){
  Object ob=get(key);
  if(ob instanceof String)return (String)ob;
  return null;
}
public String getProperty(String key,String dflt){
  if(null==key)return dflt;
  String p=getProperty(key);
  return p==null?dflt:p;
}
public Properties getProperties(String key){
  if(null==key){lg.logIt("getProperties null"); return null;}
  Object ob=get(key);
  if(ob instanceof Properties)return (Properties)ob;
  return null;
}
Enumeration propertyKeys(){return new PropertyKeysEnum();}
Enumeration simpleKeys(){return new SimpleKeysEnum();}

private void keyVal(StringBuffer sB,Object key){
  String k=(String)key;
  sB.append(k); sB.append("=");
  sB.append(get(key).toString());
}
 public synchronized String toString(){
  StringBuffer sB=new StringBuffer();
  Enumeration pk=propertyKeys();
  if(pk.hasMoreElements())keyVal(sB,pk.nextElement());
  while(pk.hasMoreElements()){
    sB.append(", ");
    keyVal(sB,pk.nextElement());
    }
  Enumeration sk=simpleKeys();
  if(sk.hasMoreElements())keyVal(sB,sk.nextElement());
  while(sk.hasMoreElements()){
    sB.append(", ");
    keyVal(sB,sk.nextElement());
    }
  return sB.toString();
}


class PropertyKeysEnum implements Enumeration{
  int howMany; Enumeration baseEnum;
public PropertyKeysEnum(){
  howMany=compoundKeys;
  baseEnum=keys();
}
public boolean hasMoreElements(){return howMany>0;}
public Object nextElement(){
  Object ob;
  while(baseEnum.hasMoreElements()){
    Object k=baseEnum.nextElement();
    Object v=get(k);
    if(v instanceof Properties){
      howMany--;
      return k;
      }
    }
  howMany=0;
  return null;
}

}    

class SimpleKeysEnum implements Enumeration{
  int howMany; Enumeration baseEnum;
public SimpleKeysEnum(){
  howMany=simpleKeys;
  baseEnum=keys();
}
public boolean hasMoreElements(){return howMany>0;}
public Object nextElement(){
  Object ob;
  while(baseEnum.hasMoreElements()){
    Object k=baseEnum.nextElement();
    Object v=get(k);
    if(v instanceof String){
      howMany--;
      return k;
      }
    }
  howMany=0;
  return null;
}

}     

}