package com.wrox.projsp.ch19;
import java.sql.*;  

public class ResultatRequeteTable implements ResultatRequete {

private String nom=null;
private String[]entetesColonnes=null;
private String[]typesColonnes=null;
private String[][]lignes=null;

public ResultatRequeteTable(String nom,String[]lbls,String[]types,String[][]lignes){
  this.nom=nom; entetesColonnes=lbls; typesColonnes=types; this.lignes=lignes;
  if(lignes==null)lignes=new String[0][];
}
public ResultatRequeteTable(String nom,ResultSet R)throws SQLException{
  this.nom=nom;
  entetesColonnes=MiscDB.resultSetLabels(R);
  typesColonnes=MiscDB.resultSetTypes(R);
  lignes=MiscDB.resultRowsToRowMatrix(R);
  if(lignes==null)lignes=new String[0][];
}
public String toXmlString(){ 
  if(entetesColonnes==null || typesColonnes==null)return null;
  StringBuffer sB=new StringBuffer();
  sB.append("<table name='"); sB.append(nom); sB.append("'>\n");
  sB.append("<headers>");
  for(int i=0;i<entetesColonnes.length;i++){
    sB.append("<header name='"); sB.append(entetesColonnes[i]); sB.append("' ");
    sB.append("fieldType='");   sB.append(typesColonnes[i]); sB.append("'/>");
    }
  sB.append("</headers>\n");
  for(int j=0;j<lignes.length;j++){
    sB.append("<row>");
    for(int i=0;i<entetesColonnes.length;i++){
      sB.append("<field name='"); sB.append(entetesColonnes[i]); sB.append("'>");
      sB.append(lignes[j][i]); sB.append("</field>");
      }
    sB.append("</row>\n");
  }
  sB.append("</table>");
  return sB.toString();
}


public String[] getEntetesColonnes(){return entetesColonnes;}
public String[] getTypesColonnes(){return typesColonnes;}
public String[][]getLignes(){return lignes;}

}