package com.wrox.projsp.ch19;

/* com.wrox.projsp.ch19.XSLSessionServlet est une copie de la classe XSLSessionServlet de James Clark 
distribue avec xt,  deux modifications prs : 
tout d'abord, une nouvelle ligne de fonction doPost(), consistant en un appel  doGet(). 
Ensuite, cette dernire mthode se voit ajouter deux lignes :

 String sessionID=request.getSession(true).getId();
 xsl.setParameter("theSessionID",sessionID);
*/
    

import java.io.IOException;
import java.io.File;
import java.io.Writer;
import java.net.URL;
import java.util.Enumeration;
import javax.servlet.*;
import javax.servlet.http.*;
import org.xml.sax.*;
import com.jclark.xsl.sax.*;

public class XSLSessionServlet extends HttpServlet {
  private XSLProcessor cached; Logger lg;

  public void init() throws ServletException {

	System.out.println("Init de XSLSessionServlet");
  System.setProperty("com.jclark.xsl.sax.parser","com.sun.xml.parser.Parser");
  if(lg==null)lg=new Logger();
    String stylesheet = getInitParameter("stylesheet");
    System.out.println("StyleSheet "+stylesheet);
    if (stylesheet == null)
      throw new ServletException("missing stylesheet parameter");
    cached = new XSLProcessorImpl();
    cached.setParser(createParser());
    try {
      String str=getServletContext().getResource(stylesheet).toString();
      lg.logIt("stylesheet="+stylesheet+" as resource="+str);
      InputSource in=new InputSource(str);
      cached.loadStylesheet(in);
    }
    catch (SAXException e) {
      lg.logIt("init SAX failure",e);
      throw new ServletException(e);
    }
    catch (IOException e) {
      lg.logIt("init IO failure",e);
      throw new ServletException(e);
    }
  }
  public void doPost(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
    doGet(request,response);
  }
  public void doGet(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
    	System.out.println("DoGet de XSLSessionServlet");
    lg=new Logger(); lg.logIt("started doGet of XSLsessionservlet");
// lg.logIt("request: " + request);
//    System.out.println("request: " + request.getPathTranslated());
    File inputFile = new File(request.getPathTranslated());
lg.logIt("input File created.");
    if (!inputFile.isFile()) {
      inputFile = new File(request.getPathTranslated() + ".xml");
      if (!inputFile.isFile()) {
	response.sendError(HttpServletResponse.SC_NOT_FOUND,
			   "File not found: " + request.getPathTranslated());
	return;
      }
    }
    lg.logIt("input File:" + inputFile);
lg.logIt("time to create the processor");
    XSLProcessor xsl = (XSLProcessor)cached.clone();
    xsl.setParser(createParser());
    for (Enumeration e = request.getParameterNames(); e.hasMoreElements();) {
      String name = (String)e.nextElement();
      // What to do about multiple values?
      xsl.setParameter(name, request.getParameter(name));
    }
    lg.logIt("set params, about to set session iD");
    String sessionID=request.getSession(true).getId();
    lg.logIt("sessionID="+sessionID);
    xsl.setParameter("theSessionID",sessionID);
lg.logIt("set sess param");
    OutputMethodHandlerImpl outputMethodHandler = new OutputMethodHandlerImpl(xsl);
lg.logIt("got outputhandler");
    xsl.setOutputMethodHandler(outputMethodHandler);
lg.logIt("set outputhandler");
    outputMethodHandler.setDestination(new ServletDestination(response));
lg.logIt("set destination");
	lg.logIt("Nom inputFile"+inputFile.getName());
    try {
      xsl.parse(fileInputSource(inputFile));
    }
    catch (Exception e) {
     lg.logIt("parse failure: ",e);
      throw new ServletException(e);
    }
  }

  static Parser createParser() throws ServletException {
    String parserClass = System.getProperty("com.jclark.xsl.sax.parser");
    if (parserClass == null)
      parserClass = System.getProperty("org.xml.sax.parser");
    if (parserClass == null)
      parserClass = "com.jclark.xml.sax.CommentDriver";
    try {
      return (Parser)Class.forName(parserClass).newInstance();
    }
    catch (ClassNotFoundException e) {
      throw new ServletException(e);
    }
    catch (InstantiationException e) {
      throw new ServletException(e);
    }
    catch (IllegalAccessException e) {
      throw new ServletException(e);
    }
    catch (ClassCastException e) {
      throw new ServletException(parserClass + " is not a SAX driver");
    }
  }

  /**
   * Generates an <code>InputSource</code> from a file name.
   */

  static public InputSource fileInputSource(File file) {
    String path = file.getAbsolutePath();
    String fSep = System.getProperty("file.separator");
    if (fSep != null && fSep.length() == 1)
      path = path.replace(fSep.charAt(0), '/');
    if (path.length() > 0 && path.charAt(0) != '/')
      path = '/' + path;
    try {
      return new InputSource(new URL("file", "", path).toString());
    }
    catch (java.net.MalformedURLException e) {
      throw new Error("unexpected MalformedURLException");
    }
  }

}