<xsl:stylesheet version="1.0"
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns="http://www.w3.org/TR/xhtml1/strict"
 xmlns:xqd="http://www.jclark.com/xt/java/com.wrox.projsp.ch19.XmlRequeteStringDoc"
 exclude-result-prefixes="xqd #default"
>
<xsl:output method="html" indent="yes"  />

<xsl:param name="theSessionID" select="NoHttpSessionIDProvided"/>

<xsl:template match="/">
<html>
<head><title>Meteo : vous avez demande DateTemp </title></head>
<body>
 <xsl:variable name="lignes" 
   select="xqd:resultat-requete($theSessionID)//*[name(.)='ligne']" />
 <xsl:choose>
 <xsl:when test="count($lignes)=0">
 Navre, pas de meteo pour votre code postal.
 </xsl:when>
 <xsl:otherwise>
  <p>
  <table border="1">
  <tr>
   <xsl:for-each select="$lignes[1]/*" >
    <th> <xsl:value-of select="@*" /> </th>
   </xsl:for-each>
  </tr>
  <xsl:for-each select="$lignes" >
  <tr>
   <xsl:for-each select="*" >
   <td> <xsl:value-of select="." /> </td>
  </xsl:for-each>
  </tr>
  </xsl:for-each>
 </table>
 </p>
 </xsl:otherwise>
</xsl:choose>

 <form method="POST" action="meteo.jsp" >
 Code Postal ?<input name="QP1" type="TEXT" size="10" /><br />
  Requete ?<select name="requete" size="1">
  <option selected="yes" value="DateTemp"> Date et temperature </option>
  <option value="TousChamps"> Tous les champs </option>
  <option value="TousTextes"> Tous les champs mis en forme </option>
 </select><BR />
 <input type="submit" value="valider" />
 </form>
 </body>
</html>
 </xsl:template>
</xsl:stylesheet>
