<xsl:stylesheet version="1.0"
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:xqd="http://www.jclark.com/xt/java/com.wrox.projsp.ch19.XmlRequeteStringDoc"
 xmlns="http://www.w3.org/TR/xhtml1/strict"
 xmlns:javaout="http://www.jclark.com/xt/java"
 exclude-result-prefixes="javaout xqd #default"
>
<xsl:output  method="javaout:com.wrox.projsp.ch19.XMLOutputHandler"
  indent="yes"
  encoding="UTF-8"
  media-type="text/vnd.wap.wml"
  omit-xml-declaration="no"
  doctype-public="-//PHONE.COM//DTD WML 1.1//EN" 
  doctype-system="http://www.phone.com/dtd/wml11.dtd"
 />
<xsl:param name="theSessionID" select="NoHttpSessionIDProvided"/>
<xsl:template match="/">
 <wml>
 <head>
  <meta http-equiv="Cache-Control" content="no-cache" forua="true"/> 
 </head>
 <card id="output" title="TousChamps">
  <do type="accept" label="encore" >
   <go href="#demanderCarte" />
  </do>
<xsl:variable name="lignes" select="xqd:resultat-requete($theSessionID)//*[name(.)='ligne']" />
  <xsl:choose>
 <xsl:when test="count($lignes)=0">
 <p mode="nowrap">
 Navre, aucune meteo pour votre code postal.
 </p>
 </xsl:when>
 <xsl:otherwise>
  <p>
  <table columns="2">
   <xsl:for-each select="$lignes[1]/*" ><!-- une ligne pour chaque en-tete -->
    <tr>
     <td> <xsl:value-of select="@*" /> </td>
     <td> <xsl:value-of select="." /> </td>
    </tr>
   </xsl:for-each>
 </table>
 </p>
 </xsl:otherwise>
</xsl:choose>
 </card>
 <card id="demanderCarte" title="Meteo">
<do type="accept" label="Valider" > 
 <go href="meteo.jsp">
   <postfield name="requete" value="$requete" />
   <postfield name="QP1" value="$QP1" />
   <postfield name="cible" value="wml-$(requete)" />
 </go>
 </do>
<p align="center">Page Meteo</p>
<p>
 Code Postal ?	<input name="QP1" format="*N" maxlength="10" value="" /><br />
Requete?	<select name="requete">
	 <option value="DateTemp" > date et temperature </option>
	 <option value="TousChamps" > Tous les champs</option>
	 <option value="TousTextes" > Tous les champs mis en forme</option>
	</select>
</p>
</card>
</wml>
</xsl:template></xsl:stylesheet>


