<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:xqd="http://www.jclark.com/xt/java/com.wrox.projsp.ch19.XmlRequeteStringDoc"
  xmlns:pruner="http://www.jclark.com/xt/java/com.wrox.projsp.ch19.XSLPrune"
  xmlns="http://www.w3.org/TR/xhtml1/strict"
  xmlns:javaout="http://www.jclark.com/xt/java"
  exclude-result-prefixes="javaout xqd pruner #default"
>
<xsl:output   method="javaout:com.wrox.projsp.ch19.XMLOutputHandler"
  indent="yes" encoding="UTF-8"
    media-type="text/vnd.wap.wml" omit-xml-declaration="no"
    doctype-public="-//PHONE.COM//DTD WML 1.1//EN" 
    doctype-system="http://www.phone.com/dtd/wml11.dtd"
 />
<xsl:param name="theSessionID" select="NoHttpSessionIDProvided"/>
<xsl:template match="/">
<wml>
<head>
  <meta http-equiv="Cache-Control" content="no-cache" forua="true"/>  
</head>
 <xsl:variable name="lignes" select="xqd:resultat-requete($theSessionID)//*[name(.)='ligne']" />
 <xsl:choose>
 <xsl:when test="count($lignes)=0">
  <card id="output" title="TousTextes">
    <do type="accept" label="encore" > <go href="#demanderCarte" />  </do>
   <p mode="nowrap">
    Navre, aucune meteo pour votre code postal.
   </p>
</card>
 </xsl:when>
 <xsl:otherwise>
<!--  CodePostal,Jour,DateEnreg,Temp,TempBasse,TempHaute,Precip.,Avertissement,Demain,Surlendemain -->
 <xsl:variable name="PLim" select="200"/> <!-- limite de deux cent caracteres -->
 <xsl:variable name="CodePostal" select="$lignes/*[@*='CodePostal']"/>
 <xsl:variable name="Jour" select="$lignes/*[@*='Jour']"/>
 <xsl:variable name="DateEnreg" select="$lignes/*[@*='DateEnreg']"/>
 <xsl:variable name="Temp" select="$lignes/*[@*='Temp']"/>
 <xsl:variable name="TempBasse" select="$lignes/*[@*='TempBasse']"/>
 <xsl:variable name="TempHaute" select="$lignes/*[@*='TempHaute']"/>
 <xsl:variable name="Precip" select="$lignes/*[@*='Precip']"/>
 <xsl:variable name="Avertissement" select="$lignes/*[@*='Avertissement']"/>
 <xsl:variable name="Demain" select="$lignes/*[@*='Demain']"/>
 <xsl:variable name="Surlendemain" select="$lignes/*[@*='Surlendemain']"/>
  <card id="output" title="TousTextes">
    <do type="accept" label="encore" > <go href="#demanderCarte" />  </do>
    <do type="accept" label="details" > <go href="#details" />  </do>
<p>
Code postal: 
<xsl:value-of select="pruner:prune($theSessionID,string($CodePostal),$PLim)"/>
<br/>
Temperature : 
<xsl:value-of select="pruner:prune($theSessionID,string($Temp),$PLim)"/>
<br/>
a 
<xsl:value-of select="pruner:prune($theSessionID,string($DateEnreg),$PLim)"/>
<br/>
Temp. minimale : 
<xsl:value-of select="pruner:prune($theSessionID,string($TempBasse),$PLim)"/>
<br/>
Temp. maximale : 
<xsl:value-of select="pruner:prune($theSessionID,string($TempHaute),$PLim)"/>
</p>
</card> 
<card id="details" title="TousTextes">
  <do type="accept" label="encore" > <go href="#demanderCarte" />  </do>
  <do type="accept" label="plus" > <go href="#plusDetails" />  </do>
<p>
Jour: 
<xsl:value-of select="pruner:prune($theSessionID,string($Jour),$PLim)"/>
<br/>
precip: 
<xsl:value-of select="pruner:prune($theSessionID,string($Precip),$PLim)"/>%
</p>
</card>
<card id="plusDetails" title="TousTextes">
  <do type="accept" label="encore" > <go href="#demanderCarte" />  </do>
  <do type="accept" label="bases" > <go href="#output" />  </do>
<xsl:if test="$Avertissement">
<p> Avertissement:
<xsl:value-of select="pruner:prune($theSessionID,string($Avertissement),$PLim)"/>
</p>
</xsl:if>
<p>
Demain: 
<xsl:value-of select="pruner:prune($theSessionID,string($Demain),$PLim)"/>
<br/>
Surlendemain: 
<xsl:value-of select="pruner:prune($theSessionID,string($Surlendemain),$PLim)"/>
</p>
</card>
 </xsl:otherwise>
</xsl:choose>

 <card id="demanderCarte" title="Meteo">
<do type="accept" label="Valider" > 
 <go href="meteo.jsp">
   <postfield name="requete" value="$requete" />
   <postfield name="QP1" value="$QP1" />
   <postfield name="cible" value="wml-$(requete)" />
 </go>
 </do>
<p align="center">Page Meteo</p>
<p>
 Code Postal ?	<input name="QP1" format="*N" maxlength="10" value="" /><br />
Requete ?	<select name="requete">
	 <option value="DateTemp" > date et temperature </option>
	 <option value="TousChamps" > Tous les champs</option>
	 <option value="TousTextes" > Tous les champs mis en forme</option>
	</select>
</p>
</card>
</wml>
</xsl:template>

</xsl:stylesheet>



