package com.wrox.projsp.ch20;

import java.io.*;

public class WebApplication {
	
  // cette instance est une rfrence vers l'unique 
  // objet webApplication. Elle est prive, si bien 
  // que personne ne peut y accder directement
  private static WebApplication instance;

  // L'objet est cr  l'aide d'un constructeur priv
  // si bien que personne ne peut crer de nouvelle instance 
  //  l'aide du mot cl new.
  private WebApplication() { }

  // Une seule instance de l'objet est autorise 
  // grce  l'appel  la mthode 
  //   public static WebApplication instanceOf
  public static WebApplication instanceOf() {
    if (instance == null)
      instance = new WebApplication();

    return instance;
  }

  // Hashtable contenant toutes les informations globales
  java.util.Hashtable globalHash = new java.util.Hashtable();

  public Object get(String cle) {
    return globalHash.get(cle);
 }

  public void put(String cle, Object valeur) {
    globalHash.put(cle, valeur);
  }
  
  
  private WebApplication(String repertoire) {
    // Omission d'une partie de la gestion des erreurs dans un but de concision
    File potentielwebRoot = new File(repertoire);
    File potentielGlobalCfg = new File(potentielwebRoot,
                                       "Global.cfg");
    // Trouver le fichier en remontant l'arborescence
    while (!potentielGlobalCfg.exists()) {
      potentielwebRoot = new File(
                             potentielwebRoot.getParent());
      potentielGlobalCfg = new File(potentielwebRoot,
                                    "Global.cfg");      
    }

    // Lire maintenant le fichier identifi et 
    // s'en servir pour initialiser l'objet.
  }

  public static WebApplication instanceOf(String repertoire) {
    if (instance == null)
      instance = new WebApplication(repertoire);

    return instance;
  }

}