/***********************
* Actions de compositions pour Adobe Edge Animate
*
* Modifier ce fichier avec précaution, en veillant à conserver 
* les signatures et les commentaires de fonction commençant par « Edge » pour maintenir la 
* possibilité d’interagir avec ces actions depuis Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // alias pour les classes Edge couramment utilisées

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      var position=0;
      
      
      Symbol.bindElementAction(compId, symbolName, "window", "devicemotion", function(sym, e) {
      		
      		ax = Math.round(event.accelerationIncludingGravity.x);
      		ay = Math.round(event.accelerationIncludingGravity.y);
      		
      		rotation = event.rotationRate;
      		if (rotation != null) {
      			arAlpha = Math.round(rotation.alpha);
      			arBeta = Math.round(rotation.beta);
      		}
      		
      		sym.$("axex").text(ax);
      		sym.$("axey").text(ay);
      		
      		sym.$("valAlpha").text(arAlpha);
      		sym.$("valBeta").text(arBeta);
      		
      		sym.$("formeGrande").css({left:325-(event.accelerationIncludingGravity.y*30)});
      		sym.$("formeMoyenne").css({left:359-(event.accelerationIncludingGravity.y*20)});
      		sym.$("formePetite").css({left:390-(event.accelerationIncludingGravity.y*10)});
      		
      		sym.$("formeGrande").css({top:140-(event.accelerationIncludingGravity.x*30)});
      		sym.$("formeMoyenne").css({top:150-(event.accelerationIncludingGravity.x*20)});
      		sym.$("formePetite").css({top:159-(event.accelerationIncludingGravity.x*10)});
      		
      		sym.$("barreGauche").css({width:80+Math.abs(arAlpha)});
      		sym.$("barreDroite").css({height:80+Math.abs(arBeta)});
      		

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

})(jQuery, AdobeEdge, "EDGE-659503392");