/***********************
* Actions de compositions pour Adobe Edge Animate
*
* Modifier ce fichier avec précaution, en veillant à conserver 
* les signatures et les commentaires de fonction commençant par « Edge » pour maintenir la 
* possibilité d’interagir avec ces actions depuis Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // alias pour les classes Edge couramment utilisées

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      
      Symbol.bindElementAction(compId, symbolName, "${_Bouton1}", "click", function(sym, e) {
         sym.$("affichage").css({color:"red"});
      
      });
      //Edge binding end
      
      
      
      Symbol.bindElementAction(compId, symbolName, "${_Bouton3}", "click", function(sym, e) {
         sym.$("affichage").css({fontWeight:"bold",textTransform:"uppercase",color:"#fee95b",backgroundColor:"#979797",padding:"10px 10px 10px 10px",width:"+=60"});

      });
      //Edge binding end
      
      Symbol.bindElementAction(compId, symbolName, "${_Bouton4}", "click", function(sym, e) {
         sym.$("affichage").css({fontFamily:"Palatino Linotype, Book Antigua, Palatino, serif"});

      });
      //Edge binding end
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         sym.getSymbol("boutonPerso").$("zoneTexte").text("Cliquez");
      
      
         sym.$("boutonPerso").click(afficherMessage);
         function afficherMessage() {
         	alert("Texte de ce bouton modifié à l'aide de cette lign d'instruction : sym.$('boutonPerso').$('zoneTexte').text('Cliquez')");
         }
      
      });
      //Edge binding end
      
      Symbol.bindElementAction(compId, symbolName, "${_Bouton5}", "click", function(sym, e) {
         
         var valeurActuelle = sym.$(e.currentTarget).text();
         
         if(valeurActuelle=="Centrer") {
         	sym.$("affichage").css({textAlign:"center"});
         	sym.$(e.currentTarget).text("À gauche");
         	sym.$(e.currentTarget).css({textAlign:"center"});
         }
         
         if(valeurActuelle=="À gauche") {
         	sym.$("affichage").css({textAlign:"left"});
         	sym.$(e.currentTarget).text("À droite");
         	sym.$(e.currentTarget).css({textAlign:"left"});
         }
         if(valeurActuelle=="À droite") {
         	sym.$("affichage").css({textAlign:"right"});
         	sym.$(e.currentTarget).text("Justifier");
         	sym.$(e.currentTarget).css({textAlign:"right"});
         }
         if(valeurActuelle=="Justifier") {
         	sym.$("affichage").css({textAlign:"justify"});
         	sym.$(e.currentTarget).text("Centrer");
         	sym.$(e.currentTarget).css({textAlign:"jutify"});
         }

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_Bouton6}", "click", function(sym, e) {
         sym.$("affichage").css({height:"auto"});
         	

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_Bouton2}", "click", function(sym, e) {
         sym.$("affichage").css({fontSize:10});
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

})(jQuery, AdobeEdge, "EDGE-93709553");