/***********************
* Actions de compositions pour Adobe Edge Animate
*
* Modifier ce fichier avec précaution, en veillant à conserver 
* les signatures et les commentaires de fonction commençant par « Edge » pour maintenir la 
* possibilité d’interagir avec ces actions depuis Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // alias pour les classes Edge couramment utilisées

   //Edge symbol: 'stage'
   (function(symbolName) {
      var posX;
      var posY;
      
      Symbol.bindElementAction(compId, symbolName, "${_pion}", "mousedown", function(sym, e) {
      
      
      posX = sym.$("pion").css("left");
      posY = sym.$("pion").css("top");
      
      
      });
      //Edge binding end
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         sym.$("pion").draggable();
      
      });
      //Edge binding end
      
      Symbol.bindElementAction(compId, symbolName, "${_pion}", "mouseup", function(sym, e) {
      	
      	if(sym.$("pion").position().left<200) sym.$("pion").animate({left:40,top:160},1000);
      	
      	if(sym.$("pion").position().left>=400) {
      		sym.$("pion").animate({width:20,height:20},300).animate({left:40,top:160},300).animate({width:76,height:76},2000);
      	}
      	
      	if(sym.$("pion").position().left>=200 && sym.$("pion").position().left<400) {
      		sym.$("pion").animate({left:260,top:160},1000);
      	}
      	
      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

})(jQuery, AdobeEdge, "EDGE-507125354");