/***********************
* Actions de compositions pour Adobe Edge Animate
*
* Modifier ce fichier avec précaution, en veillant à conserver 
* les signatures et les commentaires de fonction commençant par « Edge » pour maintenir la 
* possibilité d’interagir avec ces actions depuis Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // alias pour les classes Edge couramment utilisées

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "${_puce1}", "click", function(sym, e) {
         
         sym.$("carre").css({left:50,top:50,backgroundColor:"orange"});

      });
      //Edge binding end
      
      Symbol.bindElementAction(compId, symbolName, "${_puce2}", "click", function(sym, e) {
         
         sym.$("carre").css({left:250,top:300,backgroundColor:"purple"});

      });
      //Edge binding end
      
      Symbol.bindElementAction(compId, symbolName, "${_puce3}", "click", function(sym, e) {
         
         sym.$("carre").css({left:450,top:150,backgroundColor:"black"});

      });
      //Edge binding end
      
      Symbol.bindElementAction(compId, symbolName, "${_puce4}", "click", function(sym, e) {
         
         sym.$("carre").css({left:50,top:150,backgroundColor:"yellow"});

      });
      //Edge binding end
      
      Symbol.bindElementAction(compId, symbolName, "${_puce5}", "click", function(sym, e) {
         
         sym.$("carre").css({left:250,top:50,backgroundColor:"grey"});

      });
      //Edge binding end
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         sym.$(".puce").click(clique);
         
         function clique(e) {
         	localStorage.setItem("gauche", sym.$("carre").css("left"));
         	localStorage.setItem("haut", sym.$("carre").css("top"));
         	localStorage.setItem("couleur", sym.$("carre").css("backgroundColor"));
         }
         
         if(localStorage.getItem("gauche")!=null) {	
         	//Lecture des données car déjà stockées
         	sym.$("carre").css({left:localStorage.getItem("gauche"),top:localStorage.getItem("haut")});
         	sym.$("carre").css({backgroundColor:localStorage.getItem("couleur")});
         } else {
         	//Première exécution
         	localStorage.setItem("gauche",sym.$("carre").css("left"));
         	localStorage.setItem("haut",sym.$("carre").css("top"));
         	localStorage.setItem("couleur",sym.$("carre").css("backgroundColor"));
         
         }

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

})(jQuery, AdobeEdge, "EDGE-402704867");