/***********************
* Actions de compositions pour Adobe Edge Animate
*
* Modifier ce fichier avec précaution, en veillant à conserver 
* les signatures et les commentaires de fonction commençant par « Edge » pour maintenir la 
* possibilité d’interagir avec ces actions depuis Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // alias pour les classes Edge couramment utilisées

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "${_Group}", "click", function(sym, e) {
         sym.$("balle4a").animate({left:450},2000,"easeInBack");
         sym.$("balle4b").animate({left:450},2000,"easeOutBack");
         sym.$("balle4c").animate({left:450},2000,"easeInOutBack");

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_balle}", "click", function(sym, e) {
         sym.$(e.currentTarget).animate({left:450});

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_balle2}", "click", function(sym, e) {
         sym.$(e.currentTarget).animate({left:450},2000);

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_balle3}", "click", function(sym, e) {
         sym.$(e.currentTarget).delay(1000).animate({left:450},2000);

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_balle4}", "click", function(sym, e) {
         sym.$(e.currentTarget).animate({left:250}).animate({top:120}).delay(1000).animate({left:450}).animate({top:183});

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

})(jQuery, AdobeEdge, "EDGE-8553783");