/***********************
* Actions de compositions pour Adobe Edge Animate
*
* Modifier ce fichier avec précaution, en veillant à conserver 
* les signatures et les commentaires de fonction commençant par « Edge » pour maintenir la 
* possibilité d’interagir avec ces actions depuis Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // alias pour les classes Edge couramment utilisées

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      var largeurFenetre;
      
      
      Symbol.bindElementAction(compId, symbolName, "window", "resize", function(sym, e) {
         largeurFenetre=$(window).width();
         sym.$("affiche").text(largeurFenetre);
         
         if(largeurFenetre<420) {
              sym.$("photo2").hide();
              sym.$("photo3").hide();
         } 
         
         if(largeurFenetre>420 && largeurFenetre<640) {
              sym.$("photo2").show();
              sym.$("photo3").show();
         } 
         
         if(largeurFenetre<850 && largeurFenetre>640) {
              sym.$("photo3").offset({left:400,top:123});
         } 
         
         if(largeurFenetre>850) {
              sym.$("photo3").offset({left:642,top:16});
         }

      });
      //Edge binding end
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         largeurFenetre=$(window).width();
         sym.$("affiche").text(largeurFenetre);
         
         if(largeurFenetre<420) {
              sym.$("photo2").hide();
              sym.$("photo3").hide();
         } 
         
         if(largeurFenetre>420 && largeurFenetre<640) {
              sym.$("photo2").show();
              sym.$("photo3").show();
         } 
         
         if(largeurFenetre<850 && largeurFenetre>640) {
              sym.$("photo3").offset({left:400,top:123});
         } 
         
         if(largeurFenetre>850) {
              sym.$("photo3").offset({left:642,top:16});
         }

      });
      //Edge binding end
      
      
      
      

   })("stage");
   //Edge symbol end:'stage'

})(jQuery, AdobeEdge, "EDGE-35881052");