/***********************
* Actions de compositions pour Adobe Edge Animate
*
* Modifier ce fichier avec précaution, en veillant à conserver 
* les signatures et les commentaires de fonction commençant par « Edge » pour maintenir la 
* possibilité d’interagir avec ces actions depuis Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // alias pour les classes Edge couramment utilisées

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "${_caseACocher}", "click", function(sym, e) {
         
         
         if(sym.getSymbol("caseACocher").getPosition()==0) {
         	sym.getSymbol("caseACocher").stop(250);
         } else {
         	sym.getSymbol("caseACocher").stop(0.);
         }
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_numeros}", "click", function(sym, e) {
         sym.getSymbol("numeros").$("barre").css({left:"-=100"});

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_numeros2}", "click", function(sym, e) {
         
         TweenMax.to(sym.getSymbol("numeros2").$("barre"),0.5,{left:"-=100"});

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'CasesCocher_symbol_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

   })("CasesCocher_symbol_1");
   //Edge symbol end:'CasesCocher_symbol_1'

   //=========================================================
   
   //Edge symbol: 'SpriteSheetAnime'
   (function(symbolName) {   
   
   })("SpriteSheetAnime");
   //Edge symbol end:'SpriteSheetAnime'

})(jQuery, AdobeEdge, "EDGE-85761639");