/***********************
* Actions de compositions pour Adobe Edge Animate
*
* Modifier ce fichier avec précaution, en veillant à conserver 
* les signatures et les commentaires de fonction commençant par « Edge » pour maintenir la 
* possibilité d’interagir avec ces actions depuis Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // alias pour les classes Edge couramment utilisées

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "keydown", function(sym, e) {
         // insérer le code à exécuter lorsque vous appuyez sur une touche.
         // La variable “e.which” indique le code associé à la touche sur laquelle vous avez appuyé, par exemple 32 = espace
      
         if (e.which == 65) {
         	sym.getSymbol("lune1").play(2);
         }
         if (e.which == 90) {
         	sym.getSymbol("lune2").play(2);
         }
         if (e.which == 69) {
         	sym.getSymbol("lune3").play(2);
         }
         if (e.which == 82) {
         	sym.getSymbol("lune4").play(2);
         }
         if (e.which == 84) {
         	sym.getSymbol("lune5").play(2);
         }
      
      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'Eclat'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1000, function(sym, e) {
         sym.stop(0);

      });
      //Edge binding end

   })("Eclat");
   //Edge symbol end:'Eclat'

   //=========================================================
   
   //Edge symbol: 'Lune'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 500, function(sym, e) {
         sym.stop(0);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

   })("Lune");
   //Edge symbol end:'Lune'

})(jQuery, AdobeEdge, "EDGE-882078379");