/***********************
* Actions de compositions pour Adobe Edge Animate
*
* Modifier ce fichier avec précaution, en veillant à conserver 
* les signatures et les commentaires de fonction commençant par « Edge » pour maintenir la 
* possibilité d’interagir avec ces actions depuis Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // alias pour les classes Edge couramment utilisées

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      var curseurs = ["default","hand","pointer","cursor","hand","crosshair","text","wait","help","move","e-resize","ne-resize","nw-resize","n-resize","se-resize","sw-resize","s-resize","w-resize","progress","all-scroll","col-resize","no-drop","not-allowed","row-resize","vertical-text"];
      var numeroCurseur=0;
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
      
      
         //$('html,body').css('cursor','crosshair');
         //$('html,body').css({cursor:"crosshair"});
         //document.body.style.cursor = "crosshair";
      
         sym.$("affichage").text(curseurs.length);
      
      });
      //Edge binding end
      
      Symbol.bindElementAction(compId, symbolName, "${_cadre}", "click", function(sym, e) {
            sym.$("cadre").css({cursor:curseurs[numeroCurseur]});
            sym.$("affichage").text(curseurs[numeroCurseur]);
         	numeroCurseur++;
      		if(numeroCurseur>=curseurs.length){
      			numeroCurseur=0;
      		}
         	//sym.$(e.target).css({"cursor":"url(images/Arobase.png),default"});
      
      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

})(jQuery, AdobeEdge, "EDGE-253495560");