/***********************
* Actions de compositions pour Adobe Edge Animate
*
* Modifier ce fichier avec précaution, en veillant à conserver 
* les signatures et les commentaires de fonction commençant par « Edge » pour maintenir la 
* possibilité d’interagir avec ces actions depuis Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // alias pour les classes Edge couramment utilisées

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1000, function(sym, e) {
         sym.$("positionTete").text(sym.getPosition());
         sym.$("jauge").css({width:sym.getPosition()/sym.getDuration()*550});

      });
      //Edge binding end
      
      
      
      
      
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.$("dureeAnimation").text(sym.getDuration());
         sym.$("jauge").css({width:sym.getPosition()/sym.getDuration()*550});
         sym.play(0);
         sym.$("ChangerSensBouton").show();

      });
      //Edge binding end
      
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2000, function(sym, e) {
         sym.$("positionTete").text(sym.getPosition());
         sym.$("jauge").css({width:sym.getPosition()/sym.getDuration()*550});

      });
      //Edge binding end
      
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3000, function(sym, e) {
         sym.$("positionTete").text(sym.getPosition());
         sym.$("jauge").css({width:sym.getPosition()/sym.getDuration()*550});
         sym.playReverse();
         sym.$("ChangerSensBouton").hide();

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_ChangerSensBouton}", "click", function(sym, e) {
         
         
         if(sym.isPlaying()) {
         	sym.playReverse()
         	sym.$("ChangerSensBouton").hide();
         } 

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

})(jQuery, AdobeEdge, "EDGE-81791139");