/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.action;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionFormBean;
import org.apache.struts.action.ActionFormBeans;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionForwards;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMappings;
import org.apache.struts.action.AddDataSourceRule;
import org.apache.struts.digester.Digester;
import org.apache.struts.upload.MultipartRequestWrapper;
import org.apache.struts.util.FastHashMap;
import org.apache.struts.util.GenericDataSource;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.MessageResourcesFactory;
import org.apache.struts.util.RequestUtils;
import org.apache.struts.util.ServletContextWriter;
import org.xml.sax.SAXException;

public class ActionServlet
extends HttpServlet {
    protected FastHashMap actions = new FastHashMap();
    protected MessageResources application = null;
    protected String config = "/WEB-INF/struts-config.xml";
    protected String content = "text/html";
    protected FastHashMap dataSources = new FastHashMap();
    protected int debug = 0;
    protected final Locale defaultLocale = Locale.getDefault();
    protected String factoryClass = null;
    protected String formBeanClass = "org.apache.struts.action.ActionFormBean";
    protected ActionFormBeans formBeans = new ActionFormBeans();
    protected String forwardClass = "org.apache.struts.action.ActionForward";
    protected ActionForwards forwards = new ActionForwards();
    protected MessageResources internal = null;
    protected String internalName = "org.apache.struts.action.ActionResources";
    protected boolean locale = true;
    protected String mappingClass = "org.apache.struts.action.ActionMapping";
    protected ActionMappings mappings = new ActionMappings();
    protected boolean nocache = false;
    protected String[] registrations = new String[]{"-//Apache Software Foundation//DTD Struts Configuration 1.0//EN", "/org/apache/struts/resources/struts-config_1_0.dtd", "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", "/org/apache/struts/resources/web-app_2_2.dtd", "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", "/org/apache/struts/resources/web-app_2_3.dtd"};
    protected String servletMapping = null;
    protected String servletName = null;
    protected boolean validate = true;
    protected boolean validating = true;
    protected int bufferSize = 4096;
    protected String maxFileSize = "250M";
    protected String multipartClass = "org.apache.struts.upload.DiskMultipartRequestHandler";
    protected String tempDir;

    public void destroy() {
        if (this.debug >= 1) {
            this.log(this.internal.getMessage("finalizing"));
        }
        this.destroyActions();
        this.destroyApplication();
        this.destroyDataSources();
        this.destroyInternal();
    }

    public void init() throws ServletException {
        this.initActions();
        this.initInternal();
        this.initDebug();
        this.initApplication();
        try {
            this.initMapping();
        }
        catch (IOException e) {
            throw new UnavailableException(this.internal.getMessage("configIO", (Object)this.config));
        }
        this.initUpload();
        this.initDataSources();
        this.initOther();
        this.initServlet();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.process(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.process(request, response);
    }

    public void addDataSource(String key, DataSource dataSource) {
        if (key == null) {
            key = "org.apache.struts.action.DATA_SOURCE";
        }
        this.dataSources.put(key, dataSource);
    }

    public void addFormBean(ActionFormBean formBean) {
        this.formBeans.addFormBean(formBean);
    }

    public void addForward(ActionForward forward) {
        this.forwards.addForward(forward);
    }

    public void addMapping(ActionMapping mapping) {
        int n = 0;
        if (mapping.getForward() != null) {
            ++n;
        }
        if (mapping.getInclude() != null) {
            ++n;
        }
        if (mapping.getType() != null) {
            ++n;
        }
        if (n != 1) {
            String message = this.internal.getMessage("mappingType", (Object)mapping.getPath());
            this.log(message);
            throw new IllegalArgumentException(message);
        }
        this.mappings.addMapping(mapping);
    }

    public void addServletMapping(String servletName, String urlPattern) {
        if (this.debug >= 1) {
            this.log("Process servletName=" + servletName + ", urlPattern=" + urlPattern);
        }
        if (servletName == null) {
            return;
        }
        if (servletName.equals(this.servletName)) {
            this.servletMapping = urlPattern;
        }
    }

    public DataSource findDataSource(String key) {
        if (key == null) {
            return (DataSource)this.dataSources.get("org.apache.struts.action.DATA_SOURCE");
        }
        return (DataSource)this.dataSources.get(key);
    }

    public ActionFormBean findFormBean(String name) {
        return this.formBeans.findFormBean(name);
    }

    public ActionForward findForward(String name) {
        return this.forwards.findForward(name);
    }

    public ActionMapping findMapping(String path) {
        return this.mappings.findMapping(path);
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public int getDebug() {
        return this.debug;
    }

    public String getFormBeanClass() {
        return this.formBeanClass;
    }

    public String getForwardClass() {
        return this.forwardClass;
    }

    public String getMappingClass() {
        return this.mappingClass;
    }

    public String getMaxFileSize() {
        return this.maxFileSize;
    }

    public String getMultipartClass() {
        return this.multipartClass;
    }

    public MessageResources getResources() {
        return this.application;
    }

    public String getTempDir() {
        return this.tempDir;
    }

    public void log(String message, int level) {
        if (this.debug >= level) {
            this.log(message);
        }
    }

    public void reload() throws IOException, ServletException {
        if (this.debug >= 1) {
            this.log(this.internal.getMessage("reloading"));
        }
        this.destroyActions();
        this.destroyApplication();
        this.destroyDataSources();
        this.destroyInternal();
        this.initActions();
        this.initInternal();
        this.initDebug();
        this.initApplication();
        this.initMapping();
        this.initUpload();
        this.initDataSources();
        this.initOther();
    }

    public void removeFormBean(ActionFormBean formBean) {
        this.formBeans.removeFormBean(formBean);
    }

    public void removeForward(ActionForward forward) {
        this.forwards.removeForward(forward);
    }

    public void removeMapping(ActionMapping mapping) {
        this.mappings.removeMapping(mapping);
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setFormBeanClass(String formBeanClass) {
        this.formBeanClass = formBeanClass;
    }

    public void setForwardClass(String forwardClass) {
        this.forwardClass = forwardClass;
    }

    public void setMappingClass(String mappingClass) {
        this.mappingClass = mappingClass;
    }

    public void setMaxFileSize(String maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public void setMultipartClass(String multipartClass) {
        this.multipartClass = multipartClass;
    }

    public void setTempDir(String tempDir) {
        this.tempDir = tempDir;
    }

    protected void destroyActions() {
        FastHashMap fastHashMap = this.actions;
        synchronized (fastHashMap) {
            Iterator actions = this.actions.values().iterator();
            while (actions.hasNext()) {
                Action action = (Action)actions.next();
                action.setServlet(null);
            }
            this.actions.clear();
        }
    }

    protected void destroyApplication() {
        if (this.application != null) {
            this.getServletContext().removeAttribute("org.apache.struts.action.MESSAGE");
        }
        this.application = null;
    }

    protected void destroyDataSources() {
        FastHashMap fastHashMap = this.dataSources;
        synchronized (fastHashMap) {
            Iterator keys = this.dataSources.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                this.getServletContext().removeAttribute(key);
                DataSource dataSource = this.findDataSource(key);
                if (!(dataSource instanceof GenericDataSource)) continue;
                if (this.debug >= 1) {
                    this.log(this.internal.getMessage("dataSource.destroy", (Object)key));
                }
                try {
                    ((GenericDataSource)dataSource).close();
                }
                catch (SQLException e) {
                    this.log(this.internal.getMessage("destroyDataSource", (Object)key), e);
                }
            }
            this.dataSources.setFast(false);
        }
    }

    protected void destroyInternal() {
        this.internal = null;
    }

    protected void initActions() {
        FastHashMap fastHashMap = this.actions;
        synchronized (fastHashMap) {
            this.actions.setFast(false);
            this.actions.clear();
            this.actions.setFast(true);
        }
    }

    protected void initApplication() throws ServletException {
        String value = this.getServletConfig().getInitParameter("application");
        if (value == null) {
            return;
        }
        String factory = this.getServletConfig().getInitParameter("factory");
        if (this.debug >= 1) {
            this.log(this.internal.getMessage("applicationLoading", (Object)value));
        }
        try {
            String oldFactory = MessageResourcesFactory.getFactoryClass();
            if (factory != null) {
                MessageResourcesFactory.setFactoryClass(factory);
            }
            MessageResourcesFactory factoryObject = MessageResourcesFactory.createFactory();
            this.application = factoryObject.createResources(value);
            MessageResourcesFactory.setFactoryClass(oldFactory);
            value = this.getServletConfig().getInitParameter("null");
            if (value == null) {
                value = "true";
            }
            if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes")) {
                this.application.setReturnNull(true);
            } else {
                this.application.setReturnNull(false);
            }
        }
        catch (Throwable e) {
            this.log(this.internal.getMessage("applicationResources", (Object)value), e);
            throw new UnavailableException(this.internal.getMessage("applicationResources", (Object)value));
        }
        this.getServletContext().setAttribute("org.apache.struts.action.MESSAGE", (Object)this.application);
    }

    protected void initDataSources() throws ServletException {
        ServletContextWriter scw = new ServletContextWriter(this.getServletContext());
        FastHashMap fastHashMap = this.dataSources;
        synchronized (fastHashMap) {
            Iterator keys = this.dataSources.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                DataSource dataSource = this.findDataSource(key);
                try {
                    dataSource.setLogWriter(scw);
                }
                catch (SQLException e) {
                    this.log(this.internal.getMessage("initDataSource", (Object)key), e);
                    throw new ServletException(this.internal.getMessage("initDataSource", (Object)key), (Throwable)e);
                }
                if (dataSource instanceof GenericDataSource) {
                    if (this.debug >= 1) {
                        this.log(this.internal.getMessage("dataSource.init", (Object)key));
                    }
                    try {
                        ((GenericDataSource)dataSource).open();
                    }
                    catch (SQLException e) {
                        this.log(this.internal.getMessage("initDataSource", (Object)key), e);
                        throw new ServletException(this.internal.getMessage("initDataSource", (Object)key), (Throwable)e);
                    }
                }
                this.getServletContext().setAttribute(key, (Object)dataSource);
            }
            this.dataSources.setFast(true);
        }
    }

    protected void initDebug() throws ServletException {
        String value = this.getServletConfig().getInitParameter("debug");
        try {
            this.debug = Integer.parseInt(value);
        }
        catch (Throwable t) {
            this.debug = 0;
        }
    }

    protected Digester initDigester(int detail) {
        Digester digester = new Digester();
        digester.push((Object)this);
        digester.setDebug(detail);
        digester.setValidating(this.validating);
        int i = 0;
        while (i < this.registrations.length) {
            URL url = ((Object)((Object)this)).getClass().getResource(this.registrations[i + 1]);
            if (url != null) {
                digester.register(this.registrations[i], url.toString());
            }
            i += 2;
        }
        digester.addObjectCreate("struts-config/data-sources/data-source", "org.apache.struts.util.GenericDataSource", "type");
        digester.addSetProperties("struts-config/data-sources/data-source");
        digester.addRule("struts-config/data-sources/data-source", new AddDataSourceRule(digester));
        digester.addSetProperty("struts-config/data-sources/data-source/set-property", "property", "value");
        digester.addObjectCreate("struts-config/action-mappings/action", this.mappingClass, "className");
        digester.addSetProperties("struts-config/action-mappings/action");
        digester.addSetNext("struts-config/action-mappings/action", "addMapping", "org.apache.struts.action.ActionMapping");
        digester.addSetProperty("struts-config/action-mappings/action/set-property", "property", "value");
        digester.addObjectCreate("struts-config/action-mappings/action/forward", this.forwardClass, "className");
        digester.addSetProperties("struts-config/action-mappings/action/forward");
        digester.addSetNext("struts-config/action-mappings/action/forward", "addForward", "org.apache.struts.action.ActionForward");
        digester.addSetProperty("struts-config/action-mappings/action/forward/set-property", "property", "value");
        digester.addObjectCreate("struts-config/form-beans/form-bean", this.formBeanClass, "className");
        digester.addSetProperties("struts-config/form-beans/form-bean");
        digester.addSetNext("struts-config/form-beans/form-bean", "addFormBean", "org.apache.struts.action.ActionFormBean");
        digester.addSetProperty("struts-config/form-beans/form-bean/set-property", "property", "value");
        digester.addObjectCreate("struts-config/global-forwards/forward", this.forwardClass, "className");
        digester.addSetProperties("struts-config/global-forwards/forward");
        digester.addSetNext("struts-config/global-forwards/forward", "addForward", "org.apache.struts.action.ActionForward");
        digester.addSetProperty("struts-config/global-forwards/forward/set-property", "property", "value");
        return digester;
    }

    protected Digester initDigesterOld(int detail) {
        Digester digester = new Digester();
        digester.push((Object)this);
        digester.setDebug(detail);
        digester.setValidating(false);
        digester.addObjectCreate("action-mappings/action", this.mappingClass, "className");
        digester.addSetProperties("action-mappings/action");
        digester.addSetNext("action-mappings/action", "addMapping", "org.apache.struts.action.ActionMapping");
        digester.addObjectCreate("action-mappings/action/forward", this.forwardClass, "className");
        digester.addSetProperties("action-mappings/action/forward");
        digester.addSetNext("action-mappings/action/forward", "addForward", "org.apache.struts.action.ActionForward");
        digester.addSetProperty("action-mappings/action/forward/property", "name", "value");
        digester.addSetProperty("action-mappings/action/property", "name", "value");
        digester.addObjectCreate("action-mappings/forward", this.forwardClass, "className");
        digester.addSetProperties("action-mappings/forward");
        digester.addSetNext("action-mappings/forward", "addForward", "org.apache.struts.action.ActionForward");
        digester.addSetProperty("action-mappings/forward/property", "name", "value");
        return digester;
    }

    protected void initInternal() throws ServletException {
        try {
            this.internal = MessageResources.getMessageResources(this.internalName);
        }
        catch (MissingResourceException e) {
            this.log("Cannot load internal resources from '" + this.internalName + "'", e);
            throw new UnavailableException("Cannot load internal resources from '" + this.internalName + "'");
        }
    }

    protected void initMapping() throws IOException, ServletException {
        InputStream input;
        int detail;
        String value = null;
        this.mappings.setServlet(this);
        try {
            value = this.getServletConfig().getInitParameter("detail");
            detail = Integer.parseInt(value);
        }
        catch (Throwable t) {
            detail = 0;
        }
        value = this.getServletConfig().getInitParameter("validate");
        if (value != null) {
            this.validate = value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes");
        }
        if ((value = this.getServletConfig().getInitParameter("validating")) != null) {
            this.validating = value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes");
        }
        if ((value = this.getServletConfig().getInitParameter("formBean")) != null) {
            this.formBeanClass = value;
        }
        if ((value = this.getServletConfig().getInitParameter("forward")) != null) {
            this.forwardClass = value;
        }
        if ((value = this.getServletConfig().getInitParameter("mapping")) != null) {
            this.mappingClass = value;
        }
        if ((value = this.getServletConfig().getInitParameter("config")) != null) {
            this.config = value;
        }
        if (this.debug >= 1) {
            this.log(this.internal.getMessage("configInit", (Object)this.config));
        }
        if ((input = this.getServletContext().getResourceAsStream(this.config)) == null) {
            throw new UnavailableException(this.internal.getMessage("configMissing", (Object)this.config));
        }
        Digester digester = null;
        digester = this.validate ? this.initDigester(detail) : this.initDigesterOld(detail);
        try {
            try {
                this.formBeans.setFast(false);
                this.forwards.setFast(false);
                this.mappings.setFast(false);
                digester.parse(input);
                this.mappings.setFast(true);
                this.forwards.setFast(true);
                this.formBeans.setFast(true);
            }
            catch (SAXException e) {
                throw new ServletException(this.internal.getMessage("configParse", (Object)this.config), (Throwable)e);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            input.close();
            throw throwable;
        }
        input.close();
        if (!this.validate) {
            String[] paths = this.mappings.findMappings();
            int i = 0;
            while (i < paths.length) {
                String name = this.mappings.findMapping(paths[i]).getName();
                if (name != null) {
                    ActionFormBean formBean = new ActionFormBean();
                    formBean.setName(name);
                    formBean.setType(name);
                    this.formBeans.addFormBean(formBean);
                }
                ++i;
            }
        }
    }

    protected void initOther() throws ServletException {
        String value = null;
        value = this.getServletConfig().getInitParameter("content");
        if (value != null) {
            this.content = value;
        }
        if ((value = this.getServletConfig().getInitParameter("locale")) != null) {
            this.locale = "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value);
        }
        if ((value = this.getServletConfig().getInitParameter("nocache")) != null && ("true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value))) {
            this.nocache = true;
        }
        this.getServletContext().setAttribute("org.apache.struts.action.FORM_BEANS", (Object)this.formBeans);
        this.getServletContext().setAttribute("org.apache.struts.action.FORWARDS", (Object)this.forwards);
        this.getServletContext().setAttribute("org.apache.struts.action.MAPPINGS", (Object)this.mappings);
    }

    protected void initServlet() throws ServletException {
        this.servletName = this.getServletConfig().getServletName();
        Digester digester = new Digester();
        digester.push((Object)this);
        digester.setDebug(this.debug);
        digester.setValidating(false);
        int i = 0;
        while (i < this.registrations.length) {
            URL url = ((Object)((Object)this)).getClass().getResource(this.registrations[i + 1]);
            if (url != null) {
                digester.register(this.registrations[i], url.toString());
            }
            i += 2;
        }
        digester.addCallMethod("web-app/servlet-mapping", "addServletMapping", 2);
        digester.addCallParam("web-app/servlet-mapping/servlet-name", 0);
        digester.addCallParam("web-app/servlet-mapping/url-pattern", 1);
        InputStream input = null;
        try {
            try {
                input = this.getServletContext().getResourceAsStream("/WEB-INF/web.xml");
                digester.parse(input);
            }
            catch (Throwable e) {
                this.log(this.internal.getMessage("configWebXml"), e);
                Object var6_5 = null;
                if (input != null) {
                    input = null;
                }
            }
            Object var6_4 = null;
            if (input != null) {
                input = null;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (input != null) {
                input = null;
            }
            throw throwable;
        }
        if (this.debug >= 1) {
            this.log("Mapping for servlet '" + this.servletName + "' = '" + this.servletMapping + "'");
        }
        if (this.servletMapping != null) {
            this.getServletContext().setAttribute("org.apache.struts.action.SERVLET_MAPPING", (Object)this.servletMapping);
        }
    }

    protected void initUpload() throws ServletException {
        String tempDirValue;
        String maxsizeValue;
        String classValue;
        String bufferValue = this.getServletConfig().getInitParameter("bufferSize");
        if (bufferValue != null && bufferValue.length() > 0) {
            int oldBufferSize = this.bufferSize;
            try {
                this.bufferSize = Integer.parseInt(bufferValue, 10);
            }
            catch (NumberFormatException nfe) {
                if (this.debug > 0) {
                    this.log("initUpload(): invalid value \"" + this.bufferSize + "\" for " + "init-parameter \"buffer size\"" + ", defaulting to \"" + oldBufferSize + "\"");
                }
                this.bufferSize = oldBufferSize;
            }
        }
        if ((classValue = this.getServletConfig().getInitParameter("multipartClass")) != null && classValue.length() > 0) {
            this.multipartClass = classValue;
        }
        if ((maxsizeValue = this.getServletConfig().getInitParameter("maxFileSize")) != null && maxsizeValue.length() > 0) {
            this.maxFileSize = maxsizeValue;
        }
        if ((tempDirValue = this.getServletConfig().getInitParameter("tempDir")) != null && tempDirValue.length() > 0) {
            this.tempDir = tempDirValue;
        }
    }

    protected void process(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String path;
        String contentType = request.getContentType();
        String method = request.getMethod();
        if (contentType != null && contentType.startsWith("multipart/form-data") && method.equals("POST")) {
            request = new MultipartRequestWrapper(request);
        }
        if ((path = this.processPath(request)) == null) {
            if (this.debug >= 1) {
                this.log(" No path available for request URI " + request.getRequestURI());
            }
            response.sendError(400, this.internal.getMessage("processPath"));
            return;
        }
        if (this.debug >= 1) {
            this.log("Processing a " + request.getMethod() + " for " + path);
        }
        this.processLocale(request);
        this.processContent(response);
        this.processNoCache(response);
        if (!this.processPreprocess(request, response)) {
            return;
        }
        ActionMapping mapping = this.processMapping(path, request);
        if (mapping == null) {
            if (this.debug >= 1) {
                this.log(" No mapping available for path " + path);
            }
            response.sendError(400, this.internal.getMessage("processInvalid", (Object)path));
            return;
        }
        ActionForm formInstance = this.processActionForm(mapping, request);
        this.processPopulate(formInstance, mapping, request);
        if (!this.processValidate(mapping, formInstance, request, response)) {
            return;
        }
        if (!this.processForward(mapping, request, response)) {
            return;
        }
        if (!this.processInclude(mapping, request, response)) {
            return;
        }
        Action actionInstance = this.processActionCreate(mapping, request);
        if (actionInstance == null) {
            response.sendError(500, this.internal.getMessage("actionCreate", (Object)mapping.getPath()));
            return;
        }
        ActionForward forward = this.processActionPerform(actionInstance, mapping, formInstance, request, response);
        if (request instanceof MultipartRequestWrapper) {
            request = ((MultipartRequestWrapper)request).getRequest();
        }
        this.processActionForward(forward, mapping, formInstance, request, response);
    }

    protected Action processActionCreate(ActionMapping mapping, HttpServletRequest request) {
        Action actionInstance;
        String actionClass = mapping.getType();
        if (this.debug >= 1) {
            this.log(" Looking for Action instance for class " + actionClass);
        }
        if ((actionInstance = (Action)this.actions.get(actionClass)) == null) {
            FastHashMap fastHashMap = this.actions;
            synchronized (fastHashMap) {
                if (this.debug >= 1) {
                    this.log("  Double checking for Action instance already there");
                }
                if ((actionInstance = (Action)this.actions.get(actionClass)) != null) {
                    Action action = actionInstance;
                    return action;
                }
                try {
                    if (this.debug >= 1) {
                        this.log("  Creating new Action instance");
                    }
                    Class<?> clazz = Class.forName(actionClass);
                    actionInstance = (Action)clazz.newInstance();
                    actionInstance.setServlet(this);
                    this.actions.put(actionClass, actionInstance);
                }
                catch (Throwable t) {
                    this.log("Error creating Action instance for path '" + mapping.getPath() + "', class name '" + actionClass + "'", t);
                    Action action = null;
                    return action;
                }
            }
        }
        return actionInstance;
    }

    protected ActionForm processActionForm(ActionMapping mapping, HttpServletRequest request) {
        String attribute = mapping.getAttribute();
        if (attribute == null) {
            return null;
        }
        if (this.debug >= 1) {
            this.log(" Looking for ActionForm bean under attribute '" + attribute + "'");
        }
        ActionForm instance = null;
        HttpSession session = null;
        if ("request".equals(mapping.getScope())) {
            instance = (ActionForm)request.getAttribute(attribute);
        } else {
            session = request.getSession();
            instance = (ActionForm)session.getAttribute(attribute);
        }
        String name = mapping.getName();
        String className = null;
        ActionFormBean formBean = this.findFormBean(name);
        if (formBean == null) {
            return null;
        }
        className = formBean.getType();
        if (instance != null && className.equals(instance.getClass().getName())) {
            if (this.debug >= 1) {
                this.log(" Recycling existing ActionForm bean instance of class '" + className + "'");
            }
            return instance;
        }
        if (this.debug >= 1) {
            this.log(" Creating new ActionForm instance of class '" + className + "'");
        }
        try {
            instance = null;
            Class<?> clazz = Class.forName(className);
            instance = (ActionForm)clazz.newInstance();
        }
        catch (Throwable t) {
            this.log("Error creating ActionForm instance of class '" + className + "'", t);
        }
        if (instance == null) {
            return null;
        }
        if (this.debug >= 1) {
            this.log(" Storing instance under attribute '" + attribute + "' in scope '" + mapping.getScope() + "'");
        }
        if ("request".equals(mapping.getScope())) {
            request.setAttribute(attribute, (Object)instance);
        } else {
            session.setAttribute(attribute, (Object)instance);
        }
        return instance;
    }

    protected void processActionForward(ActionForward forward, ActionMapping mapping, ActionForm formInstance, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (forward != null) {
            String path = forward.getPath();
            if (forward.getRedirect()) {
                if (path.startsWith("/")) {
                    path = request.getContextPath() + path;
                }
                response.sendRedirect(response.encodeRedirectURL(path));
            } else {
                RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
                if (rd == null) {
                    response.sendError(500, this.internal.getMessage("requestDispatcher", (Object)path));
                    return;
                }
                rd.forward((ServletRequest)request, (ServletResponse)response);
            }
        }
    }

    protected ActionForward processActionPerform(Action action, ActionMapping mapping, ActionForm formInstance, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ActionForward forward = action.perform(mapping, formInstance, request, response);
        return forward;
    }

    protected void processContent(HttpServletResponse response) {
        if (this.content != null) {
            response.setContentType(this.content);
        }
    }

    protected boolean processForward(ActionMapping mapping, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        RequestDispatcher rd;
        String forward = mapping.getForward();
        if (forward == null) {
            return true;
        }
        if (request instanceof MultipartRequestWrapper) {
            request = ((MultipartRequestWrapper)request).getRequest();
        }
        if ((rd = this.getServletContext().getRequestDispatcher(forward)) == null) {
            response.sendError(500, this.internal.getMessage("requestDispatcher", (Object)forward));
            return false;
        }
        rd.forward((ServletRequest)request, (ServletResponse)response);
        return false;
    }

    protected boolean processInclude(ActionMapping mapping, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        RequestDispatcher rd;
        String include = mapping.getInclude();
        if (include == null) {
            return true;
        }
        if (request instanceof MultipartRequestWrapper) {
            request = ((MultipartRequestWrapper)request).getRequest();
        }
        if ((rd = this.getServletContext().getRequestDispatcher(include)) == null) {
            response.sendError(500, this.internal.getMessage("requestDispatcher", (Object)include));
            return false;
        }
        rd.include((ServletRequest)request, (ServletResponse)response);
        return false;
    }

    protected void processLocale(HttpServletRequest request) {
        if (!this.locale) {
            return;
        }
        HttpSession session = request.getSession();
        if (session.getAttribute("org.apache.struts.action.LOCALE") != null) {
            return;
        }
        Locale locale = request.getLocale();
        if (locale != null) {
            if (this.debug >= 1) {
                this.log("Setting locale '" + locale + "'");
            }
            session.setAttribute("org.apache.struts.action.LOCALE", (Object)locale);
        }
    }

    protected ActionMapping processMapping(String path, HttpServletRequest request) {
        ActionMapping mapping = this.findMapping(path);
        if (mapping == null) {
            mapping = this.mappings.getUnknown(request);
        }
        return mapping;
    }

    protected void processNoCache(HttpServletResponse response) throws IOException, ServletException {
        if (!this.nocache) {
            return;
        }
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 1L);
    }

    protected String processPath(HttpServletRequest request) {
        String path = null;
        path = (String)request.getAttribute("javax.servlet.include.path_info");
        if (path == null) {
            path = request.getPathInfo();
        }
        if (path != null && path.length() > 0) {
            return path;
        }
        path = (String)request.getAttribute("javax.servlet.include.servlet_path");
        if (path == null) {
            path = request.getServletPath();
        }
        int slash = path.lastIndexOf("/");
        int period = path.lastIndexOf(".");
        if (period >= 0 && period > slash) {
            path = path.substring(0, period);
        }
        return path;
    }

    protected boolean processPreprocess(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        return true;
    }

    protected void processPopulate(ActionForm formInstance, ActionMapping mapping, HttpServletRequest request) throws ServletException {
        if (formInstance == null) {
            return;
        }
        formInstance.setServlet(this);
        if (this.debug >= 1) {
            this.log(" Populating bean properties from this request");
        }
        formInstance.reset(mapping, request);
        if (mapping.getMultipartClass() != null) {
            request.setAttribute("org.apache.struts.action.mapping.multipartclass", (Object)mapping.getMultipartClass());
        }
        request.setAttribute("org.apache.struts.action.mapping.instance", (Object)mapping);
        RequestUtils.populate(formInstance, mapping.getPrefix(), mapping.getSuffix(), request);
    }

    protected boolean processValidate(ActionMapping mapping, ActionForm formInstance, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        RequestDispatcher rd;
        String uri;
        if (formInstance == null) {
            return true;
        }
        if (this.debug >= 1) {
            this.log(" Validating input form properties");
        }
        if (request.getParameter("org.apache.struts.taglib.html.CANCEL") != null || request.getParameter("org.apache.struts.taglib.html.CANCEL.x") != null) {
            if (this.debug >= 1) {
                this.log("  Cancelled transaction, no validation");
            }
            return true;
        }
        if (!mapping.getValidate()) {
            return true;
        }
        ActionErrors errors = formInstance.validate(mapping, request);
        if (errors == null || errors.empty()) {
            if (this.debug >= 1) {
                this.log("  No errors detected, accepting input");
            }
            return true;
        }
        if (formInstance.getMultipartRequestHandler() != null) {
            if (this.debug > 1) {
                this.log("  Rolling back the multipart request");
            }
            formInstance.getMultipartRequestHandler().rollback();
        }
        if ((uri = mapping.getInput()) == null) {
            if (this.debug >= 1) {
                this.log("  No input form, but validation returned errors");
            }
            response.sendError(500, this.internal.getMessage("noInput", (Object)mapping.getPath()));
            return false;
        }
        if (this.debug >= 1) {
            this.log("  Validation error(s), redirecting to: " + uri);
        }
        request.setAttribute("org.apache.struts.action.ERROR", (Object)errors);
        if (request instanceof MultipartRequestWrapper) {
            request = ((MultipartRequestWrapper)request).getRequest();
        }
        if ((rd = this.getServletContext().getRequestDispatcher(uri)) == null) {
            response.sendError(500, this.internal.getMessage("requestDispatcher", (Object)uri));
            return false;
        }
        rd.forward((ServletRequest)request, (ServletResponse)response);
        return false;
    }
}

