/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.taglib;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.struts.taglib.BaseHandlerTag;
import org.apache.struts.util.BeanUtils;
import org.apache.struts.util.MessageResources;

public final class CheckboxTag
extends BaseHandlerTag {
    protected static MessageResources messages = MessageResources.getMessageResources("org.apache.struts.taglib.LocalStrings");
    private String name = "org.apache.struts.taglib.BEAN";
    private String property = null;
    private String value = null;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public int doStartTag() throws JspException {
        String value;
        StringBuffer results = new StringBuffer("<input type=\"checkbox\"");
        results.append(" name=\"");
        results.append(this.property);
        results.append("\"");
        if (this.accessKey != null) {
            results.append(" accesskey=\"");
            results.append(this.accessKey);
            results.append("\"");
        }
        if (this.tabIndex != null) {
            results.append(" tabindex=\"");
            results.append(this.tabIndex);
            results.append("\"");
        }
        if ((value = this.value) == null) {
            Object bean = ((TagSupport)this).pageContext.findAttribute(this.name);
            if (bean == null) {
                throw new JspException(messages.getMessage("getter.bean", (Object)this.name));
            }
            try {
                value = BeanUtils.getSimpleProperty(bean, this.property);
                if (value == null) {
                    value = "";
                }
            }
            catch (IllegalAccessException e) {
                throw new JspException(messages.getMessage("getter.access", (Object)this.property, (Object)this.name));
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                throw new JspException(messages.getMessage("getter.result", (Object)this.property, (Object)t.toString()));
            }
            catch (NoSuchMethodException e) {
                throw new JspException(messages.getMessage("getter.method", (Object)this.property, (Object)this.name));
            }
        }
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("on")) {
            results.append(" checked");
        }
        results.append(this.prepareEventHandlers());
        results.append(this.prepareStyles());
        results.append(">");
        JspWriter writer = ((TagSupport)this).pageContext.getOut();
        try {
            writer.print(results.toString());
        }
        catch (IOException e) {
            throw new JspException(messages.getMessage("common.io", (Object)e.toString()));
        }
        return 2;
    }

    public int doEndTag() throws JspException {
        if (this.bodyContent == null) {
            return 6;
        }
        JspWriter writer = ((TagSupport)this).pageContext.getOut();
        try {
            writer.println(this.bodyContent.getString().trim());
        }
        catch (IOException e) {
            throw new JspException(messages.getMessage("common.io", (Object)e.toString()));
        }
        return 6;
    }

    public void release() {
        super.release();
        this.name = "org.apache.struts.taglib.BEAN";
        this.property = null;
        this.value = null;
    }
}

