// ------------------------------------------------------------
// - La programmation orientee aspect pour Java/J2EE          -
// - Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -
// - Editions Eyrolles                                        -
// -                                                          -
// - Partie II  : Les outils de la POA                        -
// - Chapitre 3 : AspectJ                                     -
// ------------------------------------------------------------

package aop.aspectj;

import java.util.Date;

/**
 * Dans l'application Gestion de commandes,
 * cet aspect introduit une date pour chaque commande.
 * 
 * @author Renaud Pawlak
 * @author Jean-Philippe Retaille
 * @author Lionel Seinturier
 */
public aspect AddDate {

    /** Attribut date introduit dans la classe Order. */
    private Date Order.date;
    
    /** 2 mthodes getDate() et setDate() introduites dans Order. */
    public Date Order.getDate() { return date; }
    public void Order.setDate(Date date) { this.date = date; }
    
    /** Un constructeur introduit dans Order. */
    public Order.new (Date date) { this.date = date; }

    /**
     * Aprs la construction d'une nouvelle instance de Order,
     * on initialise le l'attribut introduit date avec la date courante.
     */
    after() : initialization(Order.new (..)) {
        Order myOrder = (Order) thisJoinPoint.getTarget();
        myOrder.date = new Date();
    }
    
    /**
     * Coupe et code advice "artificiel" pour tester l'ajout de l'attribut date.
     * A la fin de la mthode main,
     * on cre et une instance de Order et on affiche la valeur du champ date.
     */
    after() : execution(void Customer.main(..)) {
    	Order myOrder = new Order();
    	System.out.println("Date de creation de la commande "+myOrder.date);
    }
}
