// ------------------------------------------------------------
// - La programmation orientee aspect pour Java/J2EE          -
// - Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -
// - Editions Eyrolles                                        -
// -                                                          -
// - Partie II  : Les outils de la POA                        -
// - Chapitre 3 : AspectJ                                     -
// ------------------------------------------------------------

package aop.aspectj;

import java.util.Date;
import java.util.Map;

/**
 * Dans l'application Gestion de commandes,
 * cet aspect trace les appels a la methode addItem.
 * 
 * @author Renaud Pawlak
 * @author Jean-Philippe Retaille
 * @author Lionel Seinturier
 */
public aspect TraceAspect {
    
    /**
     * Cette coupe est tres detaillee puisque seuls les appels a la methode
     * dont la signature est citee sera tracee.
     */
    pointcut toBeTraced():
        call( public void aop.aspectj.Order.addItem(String,int) );
    
    /**
     * Code advice qui affiche les messages de trace.
     */
    void around(): toBeTraced() {
        System.out.println("-> Avant appel addItem");
        proceed();
        System.out.println("-> Apres appel addItem");
    }
    
}
