// ------------------------------------------------------------
// - La programmation orientee aspect pour Java/J2EE          -
// - Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -
// - Editions Eyrolles                                        -
// -                                                          -
// - Partie II  : Les outils de la POA                        -
// - Chapitre 4 : JAC                                         -
// ------------------------------------------------------------

package aop.jac;

import java.util.HashMap;
import java.util.Map;

/**
 * Dans l'application Gestion de commandes,
 * cette classe represente le catalogue d'articles disponibles.
 * 
 * @author Renaud Pawlak
 * @author Jean-Philippe Retaille
 * @author Lionel Seinturier
 */
public class Catalog {
    
    /**
     * Les tarifs.
     * Map avec comme cl la reference de l'article et
     * comme valeur le prix de l'article. 
     */ 
    private static Map tarif = new HashMap();
    
    /** Les tarifs des articles du catalogue. */
    static {
        tarif.put( "CD", new Double(15.0) );
        tarif.put( "DVD", new Double(20.0) );
    }
    
    /**
     * Calcul du prix d'un article.
     * 
     * @param reference  la reference de l'article.
     * @return           le prix de l'article.
     */
    public static double getPrice( String reference ) {
        Double prix = (Double) tarif.get(reference);
        return prix.doubleValue();
    }

}
