// ------------------------------------------------------------
// - La programmation oriente aspect pour Java/J2EE          -
// - Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -
// - Editions Eyrolles                                        -
// -                                                          -
// - Partie II  : Les outils de la POA                        -
// - Chapitre 4 : JAC                                         -
// ------------------------------------------------------------

package aop.jac;

import org.aopalliance.intercept.ConstructorInvocation;
import org.aopalliance.intercept.MethodInvocation;
import org.objectweb.jac.core.AspectComponent;
import org.objectweb.jac.core.Wrapper;

/**
 * Definition d'un gestionnaire d'exception.
 * 
 * @author Renaud Pawlak
 * @author Jean-Philippe Retaille
 * @author Lionel Seinturier
 */
public class ExceptionHandlerWrapper extends Wrapper {

    public ExceptionHandlerWrapper(AspectComponent ac) {
        super(ac);
    }
    
    /**
     * Gestionnaire d'exception.
     */
    public Object myHandler(Exception e) throws Exception {
        System.out.println(">> Exception recuperee: "+e);
        return null;
    }

    /**
     * Interception des executions de constructeurs.
     */
    public Object construct(ConstructorInvocation ci) throws Throwable {
        return proceed(ci);
    }

    /**
     * Interception des executions de methodes.
     */
    public Object invoke(MethodInvocation mi) throws Throwable {
        return proceed(mi);
    }
    
}
