// ------------------------------------------------------------
// - La programmation oriente aspect pour Java/J2EE          -
// - Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -
// - Editions Eyrolles                                        -
// -                                                          -
// - Partie II  : Les outils de la POA                        -
// - Chapitre 4 : JAC                                         -
// ------------------------------------------------------------

package aop.jac;

import org.aopalliance.intercept.ConstructorInvocation;
import org.aopalliance.intercept.MethodInvocation;
import org.objectweb.jac.core.AspectComponent;
import org.objectweb.jac.core.Wrappee;
import org.objectweb.jac.core.Wrapper;
import org.objectweb.jac.core.Wrapping;

/**
 * Dans l'application Gestion de commandes,
 * ce wrapper introduit une mthode computeAmountAndPrint
 * et illustre son utilisation.
 * 
 * @author Renaud Pawlak
 * @author Jean-Philippe Retaille
 * @author Lionel Seinturier
 */
public class RoleMethodWrapper extends Wrapper {

    public RoleMethodWrapper(AspectComponent ac) {
        super(ac);
    }
    
    /**
     * Introduction d'une methode.
     */
    public void computeAmountAndPrint( Wrappee o, String header ) {
        double amount = ((Order)o).computeAmount();
        System.out.println(
            header+"Montant de la commande : "+amount+" euro(s)");
    }

    /**
     * Interception des executions de constructeurs.
     */
    public Object construct(ConstructorInvocation ci) throws Throwable {
        return proceed(ci);
    }

    /**
     * Interception des executions de methodes.
     * La coupe definie dans RoleMethodAspect concerne la methode addItem
     * de la classe Order.
     * Apres l'execution, appel de la methode introduite.
     */
    public Object invoke(MethodInvocation mi) throws Throwable {
        Object ret = proceed(mi);
        Wrapping.invokeRoleMethod(
            (Wrappee) mi.getThis(), "computeAmountAndPrint",
            new Object[]{">> "}         
        );
        return ret;
    }
    
}
