// ------------------------------------------------------------
// - La programmation oriente aspect pour Java/J2EE          -
// - Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -
// - Editions Eyrolles                                        -
// -                                                          -
// - Partie II  : Les outils de la POA                        -
// - Chapitre 4 : JAC                                         -
// ------------------------------------------------------------

package aop.jac;

import org.objectweb.jac.core.AspectComponent;

/**
 * Dans l'application Gestion de commandes,
 * ce composant d'aspect trace les executions de la methode addItem.
 * 
 * @author Renaud Pawlak
 * @author Jean-Philippe Retaille
 * @author Lionel Seinturier
 */
public class TraceAspect extends AspectComponent {
    
    public TraceAspect() {
        /**
         * Cette coupe est tres detaillee puisque seules les executions
         * de la methode dont la signature est citee sera tracee.
         */
        pointcut(
            ".*","aop.jac.Order","addItem.*",
            "aop.jac.TraceWrapper",
            null,false);
    }

}
