// ------------------------------------------------------------
// - La programmation oriente aspect pour Java/J2EE          -
// - Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -
// - Editions Eyrolles                                        -
// -                                                          -
// - Partie II  : Les outils de la POA                        -
// - Chapitre 4 : JAC                                         -
// ------------------------------------------------------------

package aop.jac;

import org.aopalliance.intercept.ConstructorInvocation;
import org.aopalliance.intercept.MethodInvocation;
import org.objectweb.jac.core.AspectComponent;
import org.objectweb.jac.core.Wrapper;

/**
 * Dans l'application Gestion de commandes,
 * ce wrapper affiche les messages de trace.
 * 
 * @author Renaud Pawlak
 * @author Jean-Philippe Retaille
 * @author Lionel Seinturier
 */
public class TraceWrapper extends Wrapper {

    public TraceWrapper(AspectComponent ac) {
        super(ac);
    }

    /**
     * Interception des executions de constructeurs.
     */
    public Object construct(ConstructorInvocation ci) throws Throwable {
        return proceed(ci);
    }

    /**
     * Interception des executions de methodes.
     */
    public Object invoke(MethodInvocation mi) throws Throwable {
        System.out.println("-> Avant addItem");
        Object ret = proceed(mi);
        System.out.println("-> Apres addItem");
        return ret;
    }
    
}
