//------------------------------------------------------------
//- La programmation orientee aspect pour Java/J2EE          -
//- Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -
//- Editions Eyrolles                                        -
//-                                                          -
//- Partie II  : Les outils de la POA                        -
//- Chapitre 5 : JBoss AOP                                   -
//------------------------------------------------------------

package aop.jboss;

import java.util.Date;

/**
 * Dans l'application Gestion de commandes,
 * cette classe contient les elements introduits dans la classe Order.
 * 
 * @author Renaud Pawlak
 * @author Jean-Philippe Retaille
 * @author Lionel Seinturier
 */
public class Calendar implements CalendarItf {
    
    /** Reference de l'objet pour lequel l'introduction est faite. */
    private Object initial;
    
    /** Attribut introduit. */
    private Date date;
    
    public Calendar( Object initial ) {
        this.initial = initial;
        date = new Date();
    }
    
    /**
     * Methodes introduites.
     */
    public void setDate(Date date) {
        this.date = date;
    }
    public Date getDate() {
        return date;
    }
    
}
