#!/bin/sh

echo "------------------------------------------------------------"
echo "- La programmation orientee aspect pour Java/J2EE          -"
echo "- Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -"
echo "- Editions Eyrolles                                        -"
echo "-                                                          -"
echo "- Partie II  : Les outils de la POA                        -"
echo "- Chapitre 6 : AspectWerkz                                   -"
echo "------------------------------------------------------------"

echo "--------------------------------------------"
echo "- Application: Gestion de commandes        -"
echo "- Aspect:      Introduction -"
echo "--------------------------------------------"

if [ -f $JAVA_HOME/bin/java ]
then
    if [ -f $ASPECTWERKZ_HOME/lib/aspectwerkz-0.10.jar ]
    then
        echo ---- Compilation ----

	cd ../..

        "$JAVA_HOME/bin/javac" -classpath "$CLASSPATH" -d classes src/aop/aspectwerkz/*.java

"$JAVA_HOME/bin/java" org.codehaus.aspectwerkz.definition.AspectC src classes

        echo ---- Execution ----

        "$ASPECTWERKZ_HOME/bin/aspectwerkz" -cp "classes:config/TraceAspect:$CLASSPATH" aop.aspectwerkz.Customer
    else
        echo "AspectWerkz n'a pas ete trouve."
        echo "Positionner la variable d'environnement ASPECTWERKZ_HOME dans le fichier env.sh"
    fi
else
    echo "Java n'a pas ete trouve."
    echo "Positionner la variable d'environnement JAVA_HOME dans le fichier env.sh"
fi
