// ------------------------------------------------------------
// - La programmation orientee aspect pour Java/J2EE          -
// - Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -
// - Editions Eyrolles                                        -
// -                                                          -
// - Partie II  : Les outils de la POA                        -
// - Chapitre 6 : AspectWerkz                                 -
// ------------------------------------------------------------

package aop.aspectwerkz;

import org.codehaus.aspectwerkz.joinpoint.JoinPoint;

/**
 * Dans l'application Gestion de commandes,
 * cet aspect affiche les messages de trace.
 * 
 * @author Renaud Pawlak
 * @author Jean-Philippe Retaille
 * @author Lionel Seinturier
 */
public class TraceAspect {

    public Object trace(JoinPoint joinPoint) throws Throwable {
        System.out.println("-> Avant appel addItem");
        Object result = joinPoint.proceed();
        System.out.println("-> Apres appel addItem");
        return result;
    }
}
