#!/bin/sh

echo "------------------------------------------------------------"
echo "- La programmation orientee aspect pour Java/J2EE          -"
echo "- Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -"
echo "- Editions Eyrolles                                        -"
echo "-                                                          -"
echo "- Partie III  : Applications de la POA                        -"
echo "- Chapitre 8 : Design patterns et POA                                     -"
echo "------------------------------------------------------------"

echo "--------------------------------------------"
echo "- Application: Chain of Responsability        -"
echo "- Aspect:      Chain of Responsability -"
echo "--------------------------------------------"

if [ -f $JAVA_HOME/bin/java ]
then
    if [ -f $ASPECTJ_HOME/lib/aspectjtools.jar -a -f $ASPECTJ_HOME/lib/aspectjrt.jar ]
    then
        echo ---- Compilation ----

        "$JAVA_HOME/bin/java" -classpath "$ASPECTJ_HOME/lib/aspectjtools.jar:$ASPECTJ_HOME/lib/aspectjrt.jar:$CLASSPATH" org.aspectj.tools.ajc.Main -d ../../classes @../../default.lst

        echo ---- Execution ----

        "$JAVA_HOME/bin/java" -classpath "../../classes:$ASPECTJ_HOME/lib/aspectjrt.jar:$CLASSPATH" aop.patterns.chainofresponsability.ChainExample
    else
        echo "AspectJ n'a pas ete trouve."
        echo "Positionner la variable d'environnement ASPECTJ_HOME dans le fichier env.sh"
    fi
else
    echo "Java n'a pas ete trouve."
    echo "Positionner la variable d'environnement JAVA_HOME dans le fichier env.sh"
fi
