// ------------------------------------------------------------
// - La programmation orientee aspect pour Java/J2EE          -
// - Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -
// - Editions Eyrolles                                        -
// -                                                          -
// - Partie III : Applications de la POA                      -
// - Chapitre 8 : Design patterns et POA                      -
// ------------------------------------------------------------

package aop.patterns.accessproxy;

/**
 * Tente d'accder  la classe Stats avec les lments d'authentification
 * passs en paramtres (login, mot de passe).
 * 
 * @author Renaud Pawlak
 * @author Jean-Philippe Retaille
 * @author Lionel Seinturier
 */
public class ProxyExample {

	public static void main(String[] args) {
		Stats stats = new Stats();
		if (args.length==2) {
			AccessProxyAspect.aspectOf().setAuthentication(args[0],args[1]);
		
			stats.incOrders();
			stats.addAmount(10);
			stats.incOrders();
			stats.addAmount(10);
			stats.incOrders();
			stats.addAmount(10);
			
			System.out.println("Nbre de commandes : "+stats.getOrders());
			System.out.println("Montant total : "+stats.getTotalAmount());
			System.out.println("Statut : "+stats.getStatus());
		} else {
			System.out.println("Nombre d'arguments incorrect. Format : login password");
		}
	}
}
