// ------------------------------------------------------------
// - La programmation orientee aspect pour Java/J2EE          -
// - Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -
// - Editions Eyrolles                                        -
// -                                                          -
// - Partie III : Applications de la POA                      -
// - Chapitre 8 : Design patterns et POA                      -
// ------------------------------------------------------------

package aop.patterns.chainOfResponsability;

/**
 * Aspect abstrait correspondant au fonctionnement gnrique de la 
 * chane de responsabilit
 * 
 * @author Renaud Pawlak
 * @author Jean-Philippe Retaille
 * @author Lionel Seinturier
 */
public abstract aspect AbstractChainAspect pertarget(receiver()){
	
	protected abstract pointcut receiver();
	
	protected abstract pointcut execute();
	
	protected abstract void handle();
	
	after() : execute() {
		handle();
	}
}