// ------------------------------------------------------------
// - La programmation orientee aspect pour Java/J2EE          -
// - Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -
// - Editions Eyrolles                                        -
// -                                                          -
// - Partie III : Applications de la POA                      -
// - Chapitre 8 : Design patterns et POA                      -
// ------------------------------------------------------------

package aop.patterns.chainOfResponsability;

/**
 * Aspect concret correspondant  l'tape 1 de la 
 * chane de responsabilit
 * 
 * @author Renaud Pawlak
 * @author Jean-Philippe Retaille
 * @author Lionel Seinturier
 */
public aspect Step1ChainAspect extends AbstractChainAspect {
	
	protected pointcut receiver() : initialization(Stats.new(..));
	protected pointcut execute() : call(void Stats.incOrders());
	
	protected void handle() {
		System.out.println("OrderHandler n1");
	}
}