// ------------------------------------------------------------
// - La programmation orientee aspect pour Java/J2EE          -
// - Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -
// - Editions Eyrolles                                        -
// -                                                          -
// - Partie III : Applications de la POA                      -
// - Chapitre 8 : Design patterns et POA                      -
// ------------------------------------------------------------

package aop.patterns.command;

/**
 * Aspect abstrait correspondant au fonctionnement gnrique du
 * design pattern commande
 * 
 * @author Renaud Pawlak
 * @author Jean-Philippe Retaille
 * @author Lionel Seinturier
 */
public abstract aspect AbstractCommandAspect pertarget(receiver()){
	
	private Command command = null;
	
	public void setCommand(Command c) {
		command = c;
	}
	
	protected abstract pointcut receiver();
	
	protected abstract pointcut execute();
	
	before(Object receiver) : execute() && target(receiver) {
		command.execute(receiver);
	}
}