// ------------------------------------------------------------
// - La programmation orientee aspect pour Java/J2EE          -
// - Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -
// - Editions Eyrolles                                        -
// -                                                          -
// - Partie III : Applications de la POA                      -
// - Chapitre 8 : Design patterns et POA                      -
// ------------------------------------------------------------

package aop.patterns.observer;

/**
 * Aspect concret correspondant  l'observateur du chiffre d'affaires
 * 
 * @author Renaud Pawlak
 * @author Jean-Philippe Retaille
 * @author Lionel Seinturier
 */
public aspect AmountObserverAspect extends AbstractObserverAspect {
	
	protected pointcut event() : set(* Stats.totalAmount);

	protected pointcut subject() : initialization(Stats.new(..));

	protected void notifyEvent(Object s,Object o) {
		Stats statistics = (Stats)s;
		AmountObserver observer = (AmountObserver)o;
		observer.eventHandler(statistics.getTotalAmount());
	}
}
