// ------------------------------------------------------------
// - La programmation orientee aspect pour Java/J2EE          -
// - Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -
// - Editions Eyrolles                                        -
// -                                                          -
// - Partie III : Applications de la POA                      -
// - Chapitre 8 : Design patterns et POA                      -
// ------------------------------------------------------------

package aop.patterns.observer;

/**
 * Programme exemple
 * 
 * @author Renaud Pawlak
 * @author Jean-Philippe Retaille
 * @author Lionel Seinturier
 */
public class ObserverExample {
	public static void main(String[] args) {
		Stats stats = new Stats();
		OrdersObserver observer1 = new OrdersObserver();
		AmountObserver observer2 = new AmountObserver();

		OrdersObserverAspect.aspectOf(stats).addObserver(observer1);
		AmountObserverAspect.aspectOf(stats).addObserver(observer2);
		
		stats.incOrders();
		stats.addAmount(10);
		stats.incOrders();
		stats.addAmount(10);
		OrdersObserverAspect.aspectOf(stats).removeObserver(observer1);
		stats.incOrders();
		stats.addAmount(10);
	}
}
