// ------------------------------------------------------------
// - La programmation orientee aspect pour Java/J2EE          -
// - Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -
// - Editions Eyrolles                                        -
// -                                                          -
// - Partie III : Applications de la POA                      -
// - Chapitre 8 : Design patterns et POA                      -
// ------------------------------------------------------------

package aop.patterns.observer;

/**
 * Aspect concret correspondant  l'observateur du nombre de commandes
 * 
 * @author Renaud Pawlak
 * @author Jean-Philippe Retaille
 * @author Lionel Seinturier
 */
public aspect OrdersObserverAspect extends AbstractObserverAspect {
	
	protected pointcut event() : set(int Stats.orders);
	
	protected pointcut subject() : initialization(Stats.new(..));

	protected void notifyEvent(Object s,Object o) {
		Stats statistics = (Stats)s;
		OrdersObserver observer = (OrdersObserver)o;
		observer.eventHandler(statistics.getOrders());
	}
}
