// ------------------------------------------------------------
// - La programmation orientee aspect pour Java/J2EE          -
// - Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -
// - Editions Eyrolles                                        -
// -                                                          -
// - Partie III : Applications de la POA                      -
// - Chapitre 8 : Design patterns et POA                      -
// ------------------------------------------------------------

package aop.patterns.singleton;

/**
 * Aspect abstrait correspondant au fonctionnement gnrique du  
 * singleton
 * 
 * @author Renaud Pawlak
 * @author Jean-Philippe Retaille
 * @author Lionel Seinturier
 */
public abstract aspect AbstractSingletonAspect {
	
    private Object singleton = null;
    
    abstract pointcut singletonPointcut();

	Object around(): singletonPointcut() {
		if (singleton == null) {
			singleton = proceed();
		}
		return singleton;
	} 
}