// ------------------------------------------------------------
// - La programmation orientee aspect pour Java/J2EE          -
// - Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -
// - Editions Eyrolles                                        -
// -                                                          -
// - Partie III : Applications de la POA                      -
// - Chapitre 8 : Design patterns et POA                      -
// ------------------------------------------------------------

package aop.patterns.strategy;

import java.io.FileOutputStream;
import java.io.PrintWriter;

/**
 * Classe implmentant la stratgie de sauvegarde dans un fichier
 * 
 * @author Renaud Pawlak
 * @author Jean-Philippe Retaille
 * @author Lionel Seinturier
 */
public class FileSaver implements Strategy {
	
	private String fileName;
	
	public FileSaver(String fileName) {
			this.fileName = fileName;
	}

	public void execute(Object receiver) {
		Stats stats = (Stats)receiver;
		
		try {
			FileOutputStream output = new FileOutputStream(fileName);
			PrintWriter writer = new PrintWriter(output);
			writer.println("STATISTIQUES :");
			writer.println("Nbre d'ordres : "+stats.getOrders());
			writer.println("Montant total : "+stats.getTotalAmount());
			writer.println("Statut : "+stats.getStatus());
			writer.flush();
			writer.close();
		}
		catch (Exception e) {
			System.err.println(e);
		}
	}
}
